package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TMapDot;

/**
 * 地图打点Mapper接口
 * 
 * @author zehong
 * @date 2024-01-17
 */
public interface TMapDotMapper 
{
    /**
     * 查询地图打点
     * 
     * @param id 地图打点ID
     * @return 地图打点
     */
    public TMapDot selectTMapDotById(Long id);

    /**
     * 查询地图打点列表
     * 
     * @param tMapDot 地图打点
     * @return 地图打点集合
     */
    public List<TMapDot> selectTMapDotList(TMapDot tMapDot);

    /**
     * 新增地图打点
     * 
     * @param tMapDot 地图打点
     * @return 结果
     */
    public int insertTMapDot(TMapDot tMapDot);

    /**
     * 修改地图打点
     * 
     * @param tMapDot 地图打点
     * @return 结果
     */
    public int updateTMapDot(TMapDot tMapDot);

    /**
     * 删除地图打点
     * 
     * @param id 地图打点ID
     * @return 结果
     */
    public int deleteTMapDotById(Long id);

    /**
     * 批量删除地图打点
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    public int deleteTMapDotByIds(Long[] ids);
}
