package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TIndustry;

/**
 * 工业用户Mapper接口
 * 
 * @author zehong
 * @date 2023-11-04
 */
public interface TIndustryMapper 
{
    /**
     * 查询工业用户
     * 
     * @param id 工业用户ID
     * @return 工业用户
     */
    public TIndustry selectTIndustryById(Long id);

    /**
     * 查询工业用户列表
     * 
     * @param tIndustry 工业用户
     * @return 工业用户集合
     */
    public List<TIndustry> selectTIndustryList(TIndustry tIndustry);

    /**
     * 新增工业用户
     * 
     * @param tIndustry 工业用户
     * @return 结果
     */
    public int insertTIndustry(TIndustry tIndustry);

    /**
     * 修改工业用户
     * 
     * @param tIndustry 工业用户
     * @return 结果
     */
    public int updateTIndustry(TIndustry tIndustry);

    /**
     * 删除工业用户
     * 
     * @param id 工业用户ID
     * @return 结果
     */
    public int deleteTIndustryById(Long id);

    /**
     * 批量删除工业用户
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    public int deleteTIndustryByIds(Long[] ids);

    /**
     * 查询工业用户入户安检信息
     * @param industry 工业用户信息
     * @return
     */
    List<TIndustry> getIndustryInspectInfo(TIndustry industry);

}
