package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TDevInspect;

/**
 * 设备检验记录（生命全周期）Mapper接口
 * 
 * @author zehong
 * @date 2023-12-15
 */
public interface TDevInspectMapper 
{
    /**
     * 查询设备检验记录（生命全周期）
     * 
     * @param id 设备检验记录（生命全周期）ID
     * @return 设备检验记录（生命全周期）
     */
    public TDevInspect selectTDevInspectById(Long id);

    /**
     * 查询设备检验记录（生命全周期）列表
     * 
     * @param tDevInspect 设备检验记录（生命全周期）
     * @return 设备检验记录（生命全周期）集合
     */
    public List<TDevInspect> selectTDevInspectList(TDevInspect tDevInspect);

    /**
     * 新增设备检验记录（生命全周期）
     * 
     * @param tDevInspect 设备检验记录（生命全周期）
     * @return 结果
     */
    public int insertTDevInspect(TDevInspect tDevInspect);

    /**
     * 修改设备检验记录（生命全周期）
     * 
     * @param tDevInspect 设备检验记录（生命全周期）
     * @return 结果
     */
    public int updateTDevInspect(TDevInspect tDevInspect);

    /**
     * 删除设备检验记录（生命全周期）
     * 
     * @param id 设备检验记录（生命全周期）ID
     * @return 结果
     */
    public int deleteTDevInspectById(Long id);

    /**
     * 批量删除设备检验记录（生命全周期）
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    public int deleteTDevInspectByIds(Long[] ids);

    /**
     * 批量新增检验记录
     * @param inspectList 检验单list
     * @return
     */
    int batchAddInspect(List<TDevInspect> inspectList);
}
