package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TDangerInspectRecordInfo;

/**
 * 隐患日常巡检记录Mapper接口
 * 
 * @author zehong
 * @date 2024-12-17
 */
public interface TDangerInspectRecordInfoMapper 
{
    /**
     * 查询隐患日常巡检记录
     * 
     * @param id 隐患日常巡检记录ID
     * @return 隐患日常巡检记录
     */
    public TDangerInspectRecordInfo selectTDangerInspectRecordInfoById(Long id);

    /**
     * 查询隐患日常巡检记录列表
     * 
     * @param tDangerInspectRecordInfo 隐患日常巡检记录
     * @return 隐患日常巡检记录集合
     */
    public List<TDangerInspectRecordInfo> selectTDangerInspectRecordInfoList(TDangerInspectRecordInfo tDangerInspectRecordInfo);

    /**
     * 新增隐患日常巡检记录
     * 
     * @param tDangerInspectRecordInfo 隐患日常巡检记录
     * @return 结果
     */
    public int insertTDangerInspectRecordInfo(TDangerInspectRecordInfo tDangerInspectRecordInfo);

    /**
     * 修改隐患日常巡检记录
     * 
     * @param tDangerInspectRecordInfo 隐患日常巡检记录
     * @return 结果
     */
    public int updateTDangerInspectRecordInfo(TDangerInspectRecordInfo tDangerInspectRecordInfo);

    /**
     * 删除隐患日常巡检记录
     * 
     * @param id 隐患日常巡检记录ID
     * @return 结果
     */
    public int deleteTDangerInspectRecordInfoById(Long id);

    /**
     * 批量删除隐患日常巡检记录
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    public int deleteTDangerInspectRecordInfoByIds(Long[] ids);
}
