package com.zehong.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 警告提醒对象 t_warning_info
 * 
 * @author zehong
 * @date 2024-09-05
 */
public class TWarningInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 警告主键 */
    private Long warningId;

    /** 用户 */
    private Long userId;

    @Excel(name = "用户昵称")
    private String nickName;

    @Excel(name = "所属部门")
    private String deptName;

    /** 设备编码 */
    @Excel(name = "设备编码")
    private String deviceCode;

    /** 静止开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "静止开始时间", width = 30, dateFormat = "yyyy-MM-dd  HH:mm:ss")
    private Date stopTime;

    /** 警告状态 */
    @Excel(name = "警告状态",dictType = "t_warning_status")
    private String warnStatus;

    public void setWarningId(Long warningId) 
    {
        this.warningId = warningId;
    }

    public Long getWarningId() 
    {
        return warningId;
    }
    public void setUserId(Long userId) 
    {
        this.userId = userId;
    }

    public Long getUserId() 
    {
        return userId;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public void setDeviceCode(String deviceCode)
    {
        this.deviceCode = deviceCode;
    }

    public String getDeviceCode() 
    {
        return deviceCode;
    }
    public void setStopTime(Date stopTime) 
    {
        this.stopTime = stopTime;
    }

    public Date getStopTime() 
    {
        return stopTime;
    }
    public void setWarnStatus(String warnStatus) 
    {
        this.warnStatus = warnStatus;
    }

    public String getWarnStatus() 
    {
        return warnStatus;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("warningId", getWarningId())
            .append("userId", getUserId())
            .append("deviceCode", getDeviceCode())
            .append("stopTime", getStopTime())
            .append("warnStatus", getWarnStatus())
            .append("updateTime", getUpdateTime())
            .append("updateBy", getUpdateBy())
            .toString();
    }
}
