package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 应急预案对象 t_urgent_plan
 * 
 * @author zehong
 * @date 2023-12-19
 */
public class TUrgentPlan extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 预案标题 */
    @Excel(name = "预案标题")
    private String title;

    /** 预案类型，1泄漏，2非计划停气或超压，3人民中毒或死亡，4火灾，,爆燃 */
    //@Excel(name = "预案类型",dictType = "urgent_plan_type")
    @Excel(name = "预案类型")
    private String type;

    /** 预案等级，1一级，2二级，3三级 */
    @Excel(name = "预案等级",dictType = "urgent_plan_level")
    private Integer level;

    /** 预案附件 */
    @Excel(name = "预案附件")
    private String fileUrl;

    /** 预案内容 */
    @Excel(name = "预案内容")
    private String content;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setTitle(String title) 
    {
        this.title = title;
    }

    public String getTitle() 
    {
        return title;
    }
    public void setType(String type)
    {
        this.type = type;
    }

    public String getType()
    {
        return type;
    }
    public void setLevel(Integer level) 
    {
        this.level = level;
    }

    public Integer getLevel() 
    {
        return level;
    }
    public void setFileUrl(String fileUrl) 
    {
        this.fileUrl = fileUrl;
    }

    public String getFileUrl() 
    {
        return fileUrl;
    }
    public void setContent(String content) 
    {
        this.content = content;
    }

    public String getContent() 
    {
        return content;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("title", getTitle())
            .append("type", getType())
            .append("level", getLevel())
            .append("fileUrl", getFileUrl())
            .append("content", getContent())
            .append("createTime", getCreateTime())
            .toString();
    }
}
