package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 应急联系人分组对象 t_urgent_contacts_group_info
 * 
 * @author zehong
 * @date 2024-12-31
 */
public class TUrgentContactsGroupInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 分组id */
    @Excel(name = "分组id")
    private String groupId;

    /** 联系人主键 */
    @Excel(name = "联系人主键")
    private Long urgentContactsId;

    private String username;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setGroupId(String groupId) 
    {
        this.groupId = groupId;
    }

    public String getGroupId() 
    {
        return groupId;
    }
    public void setUrgentContactsId(Long urgentContactsId) 
    {
        this.urgentContactsId = urgentContactsId;
    }

    public Long getUrgentContactsId() 
    {
        return urgentContactsId;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("groupId", getGroupId())
            .append("urgentContactsId", getUrgentContactsId())
            .append("createTime", getCreateTime())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
