package com.zehong.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 特殊作业单签字对象 t_special_document_sign
 * 
 * @author zehong
 * @date 2023-12-04
 */
public class TSpecialDocumentSign extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 特殊作业单id */
    @Excel(name = "特殊作业单id")
    private Long specialId;

    /** 签字人id */
    @Excel(name = "签字人id")
    private Long userId;

    /** 签字排序 0无需排序 */
    @Excel(name = "签字排序 0无需排序")
    private Integer sort;

    /** 是否 0否 1是 */
    @Excel(name = "是否 0否 1是")
    private Integer signStatus;

    /** 签字意见 */
    @Excel(name = "签字意见")
    private String signOpinion;

    /** 签字url */
    @Excel(name = "签字url")
    private String signUrl;

    /** 签字时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "签字时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date signTime;

    /** 是否可以签字 0否 1是 */
    @Excel(name = "是否可以签字 0否 1是")
    private Integer turnSign;

    private String username;

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setSpecialId(Long specialId) 
    {
        this.specialId = specialId;
    }

    public Long getSpecialId() 
    {
        return specialId;
    }
    public void setUserId(Long userId) 
    {
        this.userId = userId;
    }

    public Long getUserId() 
    {
        return userId;
    }
    public void setSort(Integer sort) 
    {
        this.sort = sort;
    }

    public Integer getSort() 
    {
        return sort;
    }
    public void setSignStatus(Integer signStatus) 
    {
        this.signStatus = signStatus;
    }

    public Integer getSignStatus() 
    {
        return signStatus;
    }
    public void setSignOpinion(String signOpinion)
    {
        this.signOpinion = signOpinion;
    }

    public String getSignOpinion()
    {
        return signOpinion;
    }
    public void setSignUrl(String signUrl)
    {
        this.signUrl = signUrl;
    }

    public String getSignUrl() 
    {
        return signUrl;
    }
    public void setSignTime(Date signTime) 
    {
        this.signTime = signTime;
    }

    public Date getSignTime() 
    {
        return signTime;
    }
    public void setTurnSign(Integer turnSign) 
    {
        this.turnSign = turnSign;
    }

    public Integer getTurnSign() 
    {
        return turnSign;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("specialId", getSpecialId())
            .append("userId", getUserId())
            .append("sort", getSort())
            .append("signStatus", getSignStatus())
            .append("signOpinion", getSignOpinion())
            .append("signUrl", getSignUrl())
            .append("signTime", getSignTime())
            .append("turnSign", getTurnSign())
            .toString();
    }
}
