package com.zehong.system.domain;

import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 管线巡线任务对象 t_pipe_task
 * 
 * @author zehong
 * @date 2023-11-17
 */
public class TPipeTask extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 巡检任务标题 */
    @Excel(name = "巡检任务标题")
    private String title;

    /** 发布日期 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "发布日期", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date pushTime;

    /** 任务类型 */
    @Excel(name = "任务类型",dictType = "t_pipe_task_type")
    private String pipeTaskType;

    /** 创建人 */

    private Long adminId;

    /** 任务结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "任务结束时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date taskEndTime;

    @Excel(name = "创建人")
    private String nickName;

    private String begindata;
    private String enddata;

    private String finishRate;

    /**计划执行日期*/
    private List<Date> planExecuteDate;

    public String getBegindata() {
        return begindata;
    }

    public void setBegindata(String begindata) {
        this.begindata = begindata;
    }

    public String getEnddata() {
        return enddata;
    }

    public void setEnddata(String enddata) {
        this.enddata = enddata;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setTitle(String title) 
    {
        this.title = title;
    }

    public String getTitle() 
    {
        return title;
    }
    public void setPushTime(Date pushTime) 
    {
        this.pushTime = pushTime;
    }

    public Date getPushTime() 
    {
        return pushTime;
    }
    public void setAdminId(Long adminId) 
    {
        this.adminId = adminId;
    }

    public Long getAdminId() 
    {
        return adminId;
    }

    public String getPipeTaskType() {
        return pipeTaskType;
    }

    public void setPipeTaskType(String pipeTaskType) {
        this.pipeTaskType = pipeTaskType;
    }

    public Date getTaskEndTime() {
        return taskEndTime;
    }

    public void setTaskEndTime(Date taskEndTime) {
        this.taskEndTime = taskEndTime;
    }

    public String getFinishRate() {
        return finishRate;
    }

    public void setFinishRate(String finishRate) {
        this.finishRate = finishRate;
    }

    public List<Date> getPlanExecuteDate() {
        return planExecuteDate;
    }

    public void setPlanExecuteDate(List<Date> planExecuteDate) {
        this.planExecuteDate = planExecuteDate;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("title", getTitle())
            .append("pushTime", getPushTime())
            .append("adminId", getAdminId())
            .append("createTime", getCreateTime())
            .toString();
    }
}
