package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 管道信息对象 t_pipe_info
 * 
 * @author zehong
 * @date 2023-11-02
 */
public class TPipeInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 管道id */
    private Long pipeId;

    /** 管道名称 */
    @Excel(name = "管道名称")
    private String pipeName;

    /** 管线类型：0中高压管线  1村内管线 */
    @Excel(name = "管线类型",dictType = "t_pipe_type")
    private String pipeType;

    /** 管道长度 */
    @Excel(name = "管道长度")
    private String pipeLength;

    /** 管径 */
    @Excel(name = "管径")
    private String pipeDiameter;

    /** 管道壁厚 */
    @Excel(name = "管道壁厚")
    private String pipeThickness;

    /** 压力 */
    @Excel(name = "压力")
    private String pipePressure;

    /** 材质（字典t_pipe_material） */
    @Excel(name = "材质", dictType = "t_pipe_material")
    private String pipeMaterial;

    /** 管道地址 */
    @Excel(name = "管道地址")
    private String pipeAddr;

    /** 敷设方式(字典t_lay_type) */
    @Excel(name = "敷设方式" ,dictType = "t_lay_type")
    private String layType;

    /** 埋深(米) */
    @Excel(name = "埋深(米)")
    private String buriedDepth;

    /** 架空高度(米) */
    @Excel(name = "架空高度(米)")
    private String overhead;

    /** 权属单位 */
    private Long beyondEnterpriseId;

    /** 权属单位名称 */
    private String beyondEnterpriseName;

    /** 坐标 */
    private String coordinates;

    /** 是否删除(0正常，1删除) */
    private String isDel;

    /** 备注 */
    private String remarks;

    //打卡点数量
    private int pointNum;

    private Long userId;

    private Integer isHasUser;

    private String isWeiXin;

    public void setPipeId(Long pipeId)
    {
        this.pipeId = pipeId;
    }

    public Long getPipeId() 
    {
        return pipeId;
    }
    public void setPipeName(String pipeName) 
    {
        this.pipeName = pipeName;
    }

    public String getPipeName() 
    {
        return pipeName;
    }

    public String getPipeType() {
        return pipeType;
    }

    public void setPipeType(String pipeType) {
        this.pipeType = pipeType;
    }

    public void setPipeLength(String pipeLength)
    {
        this.pipeLength = pipeLength;
    }

    public String getPipeLength() 
    {
        return pipeLength;
    }
    public void setPipeDiameter(String pipeDiameter) 
    {
        this.pipeDiameter = pipeDiameter;
    }

    public String getPipeDiameter() 
    {
        return pipeDiameter;
    }
    public void setPipeThickness(String pipeThickness) 
    {
        this.pipeThickness = pipeThickness;
    }

    public String getPipeThickness() 
    {
        return pipeThickness;
    }
    public void setPipePressure(String pipePressure) 
    {
        this.pipePressure = pipePressure;
    }

    public String getPipePressure() 
    {
        return pipePressure;
    }
    public void setPipeMaterial(String pipeMaterial) 
    {
        this.pipeMaterial = pipeMaterial;
    }

    public String getPipeMaterial() 
    {
        return pipeMaterial;
    }
    public void setPipeAddr(String pipeAddr) 
    {
        this.pipeAddr = pipeAddr;
    }

    public String getPipeAddr() 
    {
        return pipeAddr;
    }
    public void setLayType(String layType) 
    {
        this.layType = layType;
    }

    public String getLayType() 
    {
        return layType;
    }
    public void setBuriedDepth(String buriedDepth) 
    {
        this.buriedDepth = buriedDepth;
    }

    public String getBuriedDepth() 
    {
        return buriedDepth;
    }
    public void setOverhead(String overhead) 
    {
        this.overhead = overhead;
    }

    public String getOverhead() 
    {
        return overhead;
    }
    public void setBeyondEnterpriseId(Long beyondEnterpriseId) 
    {
        this.beyondEnterpriseId = beyondEnterpriseId;
    }

    public Long getBeyondEnterpriseId() 
    {
        return beyondEnterpriseId;
    }
    public void setBeyondEnterpriseName(String beyondEnterpriseName) 
    {
        this.beyondEnterpriseName = beyondEnterpriseName;
    }

    public String getBeyondEnterpriseName() 
    {
        return beyondEnterpriseName;
    }
    public void setCoordinates(String coordinates) 
    {
        this.coordinates = coordinates;
    }

    public String getCoordinates() 
    {
        return coordinates;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }

    public int getPointNum() {
        return pointNum;
    }

    public void setPointNum(int pointNum) {
        this.pointNum = pointNum;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Integer getIsHasUser() {
        return isHasUser;
    }

    public void setIsHasUser(Integer isHasUser) {
        this.isHasUser = isHasUser;
    }

    public String getIsWeiXin() {
        return isWeiXin;
    }

    public void setIsWeiXin(String isWeiXin) {
        this.isWeiXin = isWeiXin;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("pipeId", getPipeId())
            .append("pipeName", getPipeName())
            .append("pipeLength", getPipeLength())
            .append("pipeDiameter", getPipeDiameter())
            .append("pipeThickness", getPipeThickness())
            .append("pipePressure", getPipePressure())
            .append("pipeMaterial", getPipeMaterial())
            .append("pipeAddr", getPipeAddr())
            .append("layType", getLayType())
            .append("buriedDepth", getBuriedDepth())
            .append("overhead", getOverhead())
            .append("beyondEnterpriseId", getBeyondEnterpriseId())
            .append("beyondEnterpriseName", getBeyondEnterpriseName())
            .append("coordinates", getCoordinates())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("isDel", getIsDel())
            .append("remarks", getRemarks())
            .toString();
    }
}
