package com.zehong.system.domain;

import java.math.BigDecimal;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 事故台账对象 t_failure
 * 
 * @author zehong
 * @date 2023-12-20
 */
public class TFailure extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 事故名称 */
    @Excel(name = "事故名称")
    private String title;

    /** 事故类型，1生产安全事故，2非生产安全事故 */
    @Excel(name = "事故类型",dictType = "t_accident_type")
    private Long type;

    /** 具体地址 */
    @Excel(name = "具体地址")
    private String address;

    /** 经度 */
    @Excel(name = "经度")
    private BigDecimal longitude;

    /** 纬度 */
    @Excel(name = "纬度")
    private BigDecimal latitude;

    /** 事故原因，1泄漏事故，2爆炸事故，3中毒事故，4火灾事故，5管道破裂事故，6阀门损坏事故，7表故障事故，8灶具故障事故，9软管老化事故，10操作不当事故 */
    @Excel(name = "事故原因",dictType = "t_accident_reason")
    private Integer reason;

    /** 事故时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "事故时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date happenTime;

    /** 事故经过 */
    @Excel(name = "事故经过")
    private String content;

    /** 责任单位 */
    @Excel(name = "责任单位")
    private String company;

    /** 人员伤亡，0有，1无 */
    @Excel(name = "人员伤亡",readConverterExp = "0=有,1=无")
    private Integer loss;

    /** 责任人 */
    @Excel(name = "责任人")
    private String username;

    /** 是否处理，0未处理，1已处理 */
    @Excel(name = "是否处理",readConverterExp = "0=未处理,1=已处理")
    private Integer status;

    /** 处理时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "处理时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date finishTime;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setTitle(String title) 
    {
        this.title = title;
    }

    public String getTitle() 
    {
        return title;
    }
    public void setType(Long type) 
    {
        this.type = type;
    }

    public Long getType() 
    {
        return type;
    }
    public void setAddress(String address) 
    {
        this.address = address;
    }

    public String getAddress() 
    {
        return address;
    }
    public void setLongitude(BigDecimal longitude) 
    {
        this.longitude = longitude;
    }

    public BigDecimal getLongitude() 
    {
        return longitude;
    }
    public void setLatitude(BigDecimal latitude) 
    {
        this.latitude = latitude;
    }

    public BigDecimal getLatitude() 
    {
        return latitude;
    }
    public void setReason(Integer reason) 
    {
        this.reason = reason;
    }

    public Integer getReason() 
    {
        return reason;
    }
    public void setHappenTime(Date happenTime) 
    {
        this.happenTime = happenTime;
    }

    public Date getHappenTime() 
    {
        return happenTime;
    }
    public void setContent(String content) 
    {
        this.content = content;
    }

    public String getContent() 
    {
        return content;
    }
    public void setCompany(String company) 
    {
        this.company = company;
    }

    public String getCompany() 
    {
        return company;
    }
    public void setLoss(Integer loss) 
    {
        this.loss = loss;
    }

    public Integer getLoss() 
    {
        return loss;
    }
    public void setUsername(String username) 
    {
        this.username = username;
    }

    public String getUsername() 
    {
        return username;
    }
    public void setStatus(Integer status) 
    {
        this.status = status;
    }

    public Integer getStatus() 
    {
        return status;
    }
    public void setFinishTime(Date finishTime) 
    {
        this.finishTime = finishTime;
    }

    public Date getFinishTime() 
    {
        return finishTime;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("title", getTitle())
            .append("type", getType())
            .append("address", getAddress())
            .append("longitude", getLongitude())
            .append("latitude", getLatitude())
            .append("reason", getReason())
            .append("happenTime", getHappenTime())
            .append("content", getContent())
            .append("company", getCompany())
            .append("loss", getLoss())
            .append("username", getUsername())
            .append("status", getStatus())
            .append("finishTime", getFinishTime())
            .append("remark", getRemark())
            .append("createTime", getCreateTime())
            .toString();
    }
}
