package com.zehong.system.domain;

import java.math.BigDecimal;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 应急响应对象 t_emergency_response
 * 
 * @author zehong
 * @date 2024-09-06
 */
public class TEmergencyResponse extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 应急响应主键 */
    private Long responseId;

    /** 名称 */
    @Excel(name = "名称")
    private String title;

    /** 地址 */
    @Excel(name = "地址")
    private String address;

    /** 描述 */
    @Excel(name = "描述")
    private String description;

    /** 照片 */
    @Excel(name = "照片")
    private String photoUrl;

    /** 上报时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "上报时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date reportTime;

    /** 上报人 */
    private Long reportBy;

    @Excel(name = "上报人")
    private String nickName;

    /** 经度 */
    @Excel(name = "经度")
    private BigDecimal longitude;

    /** 纬度 */
    @Excel(name = "纬度")
    private BigDecimal latitude;

    /** 事件总结 */
    @Excel(name = "事件总结")
    private String eventSummary;

    /** 响应状态 */
    @Excel(name = "响应状态")
    private String responseStatus;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    private TEmergencyDisposeStep newStep;


    public void setResponseId(Long responseId) 
    {
        this.responseId = responseId;
    }

    public Long getResponseId() 
    {
        return responseId;
    }
    public void setTitle(String title) 
    {
        this.title = title;
    }

    public String getTitle() 
    {
        return title;
    }
    public void setAddress(String address) 
    {
        this.address = address;
    }

    public String getAddress() 
    {
        return address;
    }
    public void setDescription(String description) 
    {
        this.description = description;
    }

    public String getDescription() 
    {
        return description;
    }
    public void setPhotoUrl(String photoUrl) 
    {
        this.photoUrl = photoUrl;
    }

    public String getPhotoUrl() 
    {
        return photoUrl;
    }
    public void setReportTime(Date reportTime) 
    {
        this.reportTime = reportTime;
    }

    public Date getReportTime() 
    {
        return reportTime;
    }
    public void setReportBy(Long reportBy) 
    {
        this.reportBy = reportBy;
    }

    public Long getReportBy() 
    {
        return reportBy;
    }
    public void setLongitude(BigDecimal longitude) 
    {
        this.longitude = longitude;
    }

    public BigDecimal getLongitude() 
    {
        return longitude;
    }
    public void setLatitude(BigDecimal latitude) 
    {
        this.latitude = latitude;
    }

    public BigDecimal getLatitude() 
    {
        return latitude;
    }
    public void setEventSummary(String eventSummary) 
    {
        this.eventSummary = eventSummary;
    }

    public String getEventSummary() 
    {
        return eventSummary;
    }
    public void setResponseStatus(String responseStatus) 
    {
        this.responseStatus = responseStatus;
    }

    public String getResponseStatus() 
    {
        return responseStatus;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public TEmergencyDisposeStep getNewStep() {
        return newStep;
    }

    public void setNewStep(TEmergencyDisposeStep newStep) {
        this.newStep = newStep;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("responseId", getResponseId())
            .append("title", getTitle())
            .append("address", getAddress())
            .append("description", getDescription())
            .append("photoUrl", getPhotoUrl())
            .append("reportTime", getReportTime())
            .append("reportBy", getReportBy())
            .append("longitude", getLongitude())
            .append("latitude", getLatitude())
            .append("eventSummary", getEventSummary())
            .append("responseStatus", getResponseStatus())
            .append("remarks", getRemarks())
            .toString();
    }
}
