package com.zehong.system.domain;

import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.math.BigDecimal;

/**
 * 居民小区（村）对象 t_community
 * 
 * @author zehong
 * @date 2023-11-03
 */
public class TCommunity extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 小区名称 */
    @Excel(name = "小区名称")
    private String name;

    /** 小区简称(常用名) */
    @Excel(name = "小区简称(常用名)")
    private String sname;

    @Excel(name = "区域类型")
    private String areatypeName;

    @Excel(name = "所属市")
    private String cityName;

    @Excel(name = "所属区(县)")
    private String countyName;

    @Excel(name = "所属街道")
    private String streetName;

    /** 所属区(县) */
    //@Excel(name = "所属区(县)")
    private Long county;

    /** 所属市 */
   // @Excel(name = "所属市")
    private Long city;

    /** 所属街道（乡镇） */
   // @Excel(name = "所属街道", readConverterExp = "乡=镇")
    private Long street;

    /** 区域类型(1城镇2农村) */
    //@Excel(name = "区域类型(1城镇2农村)")
    private String areaType;

    /** 详细地址 */
    @Excel(name = "详细地址")
    private String address;

    /** 小区居民总户数 */
    @Excel(name = "小区居民总户数")
    private Long usersNum;

    /** 经度 */
    @Excel(name = "经度")
    private BigDecimal longitude;

    /** 纬度 */
    @Excel(name = "纬度")
    private BigDecimal latitude;

    public String getAreatypeName() {
        return areatypeName;
    }

    public void setAreatypeName(String areatypeName) {
        this.areatypeName = areatypeName;
    }


    public String getCityName() {
        return cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public String getCountyName() {
        return countyName;
    }

    public void setCountyName(String countyName) {
        this.countyName = countyName;
    }

    public String getStreetName() {
        return streetName;
    }

    public void setStreetName(String streetName) {
        this.streetName = streetName;
    }


    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setName(String name) 
    {
        this.name = name;
    }

    public String getName() 
    {
        return name;
    }
    public void setSname(String sname) 
    {
        this.sname = sname;
    }

    public String getSname() 
    {
        return sname;
    }
    public void setCounty(Long county)
    {
        this.county = county;
    }

    public Long getCounty()
    {
        return county;
    }
    public void setCity(Long city)
    {
        this.city = city;
    }

    public Long getCity()
    {
        return city;
    }
    public void setStreet(Long street)
    {
        this.street = street;
    }

    public Long getStreet()
    {
        return street;
    }
    public void setAreaType(String areaType) 
    {
        this.areaType = areaType;
    }

    public String getAreaType() 
    {
        return areaType;
    }
    public void setAddress(String address) 
    {
        this.address = address;
    }

    public String getAddress() 
    {
        return address;
    }
    public void setUsersNum(Long usersNum) 
    {
        this.usersNum = usersNum;
    }

    public Long getUsersNum() 
    {
        return usersNum;
    }
    public void setLongitude(BigDecimal longitude) 
    {
        this.longitude = longitude;
    }

    public BigDecimal getLongitude() 
    {
        return longitude;
    }
    public void setLatitude(BigDecimal latitude) 
    {
        this.latitude = latitude;
    }

    public BigDecimal getLatitude() 
    {
        return latitude;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("name", getName())
            .append("sname", getSname())
            .append("county", getCounty())
            .append("city", getCity())
            .append("street", getStreet())
            .append("areaType", getAreaType())
            .append("address", getAddress())
            .append("usersNum", getUsersNum())
            .append("longitude", getLongitude())
            .append("latitude", getLatitude())
            .append("remark", getRemark())
            .toString();
    }
}
