package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 地区县镇对象 t_area
 * 
 * @author zehong
 * @date 2023-11-03
 */
public class TArea extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** id */
    private Long id;

    /** 上级id */
    @Excel(name = "上级id")
    private Long parentId;

    /** 1市 2区(县) 3乡镇/街道 */
    @Excel(name = "1市 2区(县) 3乡镇/街道")
    private Integer areaLevel;

    /** 地区名称 */
    @Excel(name = "地区名称")
    private String areaName;

    /** 区划代码 */
    @Excel(name = "区划代码")
    private String areaCode;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setParentId(Long parentId) 
    {
        this.parentId = parentId;
    }

    public Long getParentId() 
    {
        return parentId;
    }
    public void setAreaLevel(Integer areaLevel) 
    {
        this.areaLevel = areaLevel;
    }

    public Integer getAreaLevel() 
    {
        return areaLevel;
    }
    public void setAreaName(String areaName) 
    {
        this.areaName = areaName;
    }

    public String getAreaName() 
    {
        return areaName;
    }
    public void setAreaCode(String areaCode) 
    {
        this.areaCode = areaCode;
    }

    public String getAreaCode() 
    {
        return areaCode;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("parentId", getParentId())
            .append("areaLevel", getAreaLevel())
            .append("areaName", getAreaName())
            .append("areaCode", getAreaCode())
            .append("createTime", getCreateTime())
            .toString();
    }
}
