package com.zehong.web.controller.usergps;

import java.util.List;

import com.alibaba.fastjson.JSONObject;
import com.zehong.common.exception.CustomException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TUserGps;
import com.zehong.system.service.ITUserGpsService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 【请填写功能名称】Controller
 * 
 * @author zehong
 * @date 2024-02-29
 */
@RestController
@RequestMapping("/user/gps")
public class TUserGpsController extends BaseController
{
    @Autowired
    private ITUserGpsService tUserGpsService;

    /**
     * 查询【请填写功能名称】列表
     */
    @PreAuthorize("@ss.hasPermi('user:gps:list')")
    @GetMapping("/list")
    public TableDataInfo list(TUserGps tUserGps){
        startPage();
        List<TUserGps> list = tUserGpsService.selectTUserGpsList(tUserGps);
        return getDataTable(list);
    }

    /**
     * 导出【请填写功能名称】列表
     */
    @PreAuthorize("@ss.hasPermi('user:gps:export')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TUserGps tUserGps)
    {
        List<TUserGps> list = tUserGpsService.selectTUserGpsList(tUserGps);
        ExcelUtil<TUserGps> util = new ExcelUtil<TUserGps>(TUserGps.class);
        return util.exportExcel(list, "【请填写功能名称】数据");
    }

    /**
     * 获取【请填写功能名称】详细信息
     */
    @PreAuthorize("@ss.hasPermi('user:gps:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tUserGpsService.selectTUserGpsById(id));
    }

    /**
     * 新增【请填写功能名称】
     */
    @PreAuthorize("@ss.hasPermi('user:gps:add')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TUserGps tUserGps){
        int result = tUserGpsService.insertTUserGps(tUserGps);
        if(-1 == result){
            return AjaxResult.error("用户已绑定设备编码请修改");
        }
        return toAjax(result);
    }

    /**
     * 修改【请填写功能名称】
     */
    @PreAuthorize("@ss.hasPermi('user:gps:edit')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TUserGps tUserGps)
    {
        return toAjax(tUserGpsService.updateTUserGps(tUserGps));
    }

    /**
     * 删除【请填写功能名称】
     */
    @PreAuthorize("@ss.hasPermi('user:gps:remove')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tUserGpsService.deleteTUserGpsByIds(ids));
    }

    /**
     * 获取当前位置
     * @param id 设备编号
     * @return
     */
    @GetMapping("/getCurrentLocation")
    public AjaxResult getCurrentLocation(String id){
        JSONObject result = tUserGpsService.getCurrentLocation(id);
        if(null != result){
            return AjaxResult.success(result);
        }
        return AjaxResult.error("获取当前位置失败");
    }

    /**
     * 获取登录用户当前位置
     * @return
     */
    @GetMapping("/getCurrentLocationByUser")
    public AjaxResult getCurrentLocationByUser(){
        try{
            JSONObject result = tUserGpsService.getCurrentLocationByUser();
            if(null != result) return AjaxResult.success(result);
        }catch (CustomException e){
            return AjaxResult.error(e.getMessage());
        }catch (Throwable ab){
            return AjaxResult.error("获取当前位置失败");
        }
        return AjaxResult.error("获取当前位置失败");
    }

    /**
     * 定位历史轨迹
     * @param id 设备编号
     * @param startTime 开始时间
     * @param endTime 结束时间
     * @return
     */
    @GetMapping("/historyTrack")
    public AjaxResult historyTrack(String id,String startTime,String endTime){
        JSONObject result = tUserGpsService.historyTrack(id,startTime,endTime);
        if(null != result && "2002".equals(result.getString("state"))){
            return AjaxResult.error("没有查询到任何结果");
        }
        if(null != result){
            return AjaxResult.success(result);
        }
        return AjaxResult.error("获取定位历史轨迹失败");
    }
}
