package com.zehong.web.controller.screenstatistic;

import com.zehong.common.core.domain.AjaxResult;
import com.zehong.system.service.TScreenStatisticService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import java.util.HashMap;
import java.util.Map;

/**
 * 首页统计
 */
@RestController
@RequestMapping("/screen/statistic")
public class TScreenStatisticController {

    @Autowired
    private TScreenStatisticService screenStatisticService;

    /**
     * 考勤打卡统计
     * @return
     */
    @GetMapping("/clockStatistic")
    public AjaxResult clockStatistic(){
        return AjaxResult.success(screenStatisticService.clockStatistic());
    }

    /**
     * 最新任务统计
     * @param type 用户类型
     * @param checkType 检查类型
     * @return
     */
    @GetMapping("/userCurrentTaskStatistic")
    public AjaxResult userCurrentTaskStatistic(@RequestParam(value = "type") Integer type,@RequestParam(value = "checkType",required = false) Integer checkType){
        Map<String,Object> param = new HashMap<>();
        param.put("type",type);
        param.put("checkType",checkType);
        return AjaxResult.success(screenStatisticService.userCurrentTaskStatistic(param));
    }

    /**
     * 最新巡检统计
     * @param type 用户类型
     * @return
     */
    @GetMapping("/userCurrentInspectStatistic")
    public AjaxResult userCurrentInspectStatistic(@RequestParam(value = "type") Integer type){
        Map<String,Object> param = new HashMap<>();
        param.put("type",type);
        return AjaxResult.success(screenStatisticService.userCurrentInspectStatistic(param));
    }

    /**
     * 设备生命周期统计
     * @return
     */
    @GetMapping("/devLifeStatistic")
    public AjaxResult devLifeStatistic(){
        return AjaxResult.success(screenStatisticService.devLifeStatistic());
    }

    /**
     * 隐患统计
     * @return
     */
    @GetMapping("/dangerStatistic")
    public AjaxResult dangerStatistic(){
        return AjaxResult.success(screenStatisticService.dangerStatistic());
    }
}
