package com.zehong.web.controller.baseinfo;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TUser;
import com.zehong.system.service.ITUserService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 居民用户Controller
 * 
 * @author zehong
 * @date 2023-11-03
 */
@RestController
@RequestMapping("/system/jmuser")
public class TUserController extends BaseController
{
    @Autowired
    private ITUserService tUserService;

    /**
     * 查询居民用户列表
     */
    //@PreAuthorize("@ss.hasPermi('system:user:list')")
    @GetMapping("/list")
    public TableDataInfo list(TUser tUser)
    {
        startPage();
        List<TUser> list = tUserService.selectTUserList(tUser);
        return getDataTable(list);
    }

    /**
     * 导出居民用户列表
     */
    //@PreAuthorize("@ss.hasPermi('system:user:export')")
    @Log(title = "居民用户", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TUser tUser)
    {
        List<TUser> list = tUserService.selectTUserList(tUser);
        ExcelUtil<TUser> util = new ExcelUtil<TUser>(TUser.class);
        return util.exportExcel(list, "居民用户数据");
    }

    /**
     * 获取居民用户详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:user:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tUserService.selectTUserById(id));
    }

    @GetMapping(value = "userInfo/{id}")
    public AjaxResult getUserInfo(@PathVariable("id") Long id){
        return AjaxResult.success(tUserService.selectTUserById(id));
    }

    /**
     * 新增居民用户
     */
    //@PreAuthorize("@ss.hasPermi('system:user:add')")
    @Log(title = "居民用户", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TUser tUser)
    {
        return toAjax(tUserService.insertTUser(tUser));
    }

    /**
     * 修改居民用户
     */
    //@PreAuthorize("@ss.hasPermi('system:user:edit')")
    @Log(title = "居民用户", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TUser tUser)
    {
        return toAjax(tUserService.updateTUser(tUser));
    }

    /**
     * 删除居民用户
     */
    //@PreAuthorize("@ss.hasPermi('system:user:remove')")
    @Log(title = "居民用户", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tUserService.deleteTUserByIds(ids));
    }
}
