package com.zehong.web.controller.baseinfo;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TSiteStationInfo;
import com.zehong.system.service.ITSiteStationInfoService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 场站信息Controller
 * 
 * @author zehong
 * @date 2023-11-02
 */
@RestController
@RequestMapping("/baseInfo/station")
public class TSiteStationInfoController extends BaseController
{
    @Autowired
    private ITSiteStationInfoService tSiteStationInfoService;

    /**
     * 查询场站信息列表
     */
    //@PreAuthorize("@ss.hasPermi('baseInfo:station:list')")
    @GetMapping("/list")
    public TableDataInfo list(TSiteStationInfo tSiteStationInfo)
    {
        startPage();
        List<TSiteStationInfo> list = tSiteStationInfoService.selectTSiteStationInfoList(tSiteStationInfo);
        return getDataTable(list);
    }

    @GetMapping("/stationInfoList")
    public AjaxResult stationInfoList(TSiteStationInfo tSiteStationInfo){
        List<TSiteStationInfo> list = tSiteStationInfoService.selectTSiteStationInfoList(tSiteStationInfo);
        return AjaxResult.success(list);
    }

    /**
     * 小程序 巡检状态
     * @param tSiteStationInfo
     * @return
     */
    @GetMapping("/stationlist")
    public TableDataInfo stationInspectList(TSiteStationInfo tSiteStationInfo)
    {
        startPage();
        List<TSiteStationInfo> list = tSiteStationInfoService.stationInspectList(tSiteStationInfo);
        return getDataTable(list);
    }

    /**
     * 导出场站信息列表
     */
    //@PreAuthorize("@ss.hasPermi('baseInfo:station:export')")
    @Log(title = "场站信息", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TSiteStationInfo tSiteStationInfo)
    {
        List<TSiteStationInfo> list = tSiteStationInfoService.selectTSiteStationInfoList(tSiteStationInfo);
        ExcelUtil<TSiteStationInfo> util = new ExcelUtil<TSiteStationInfo>(TSiteStationInfo.class);
        return util.exportExcel(list, "场站信息数据");
    }

    /**
     * 获取场站信息详细信息
     */
    //@PreAuthorize("@ss.hasPermi('baseInfo:station:query')")
    @GetMapping(value = "/{siteStationId}")
    public AjaxResult getInfo(@PathVariable("siteStationId") Long siteStationId)
    {
        return AjaxResult.success(tSiteStationInfoService.selectTSiteStationInfoById(siteStationId));
    }

    /**
     * 获取安检模板
     * @param stationId
     * @return
     */
    @GetMapping(value = "site/{stationId}")
    public AjaxResult getJson(@PathVariable("stationId") Long stationId)
    {
        return AjaxResult.success(tSiteStationInfoService.selectStationJsonById(stationId));
    }
    /**
     * 新增场站信息
     */
    //@PreAuthorize("@ss.hasPermi('baseInfo:station:add')")
    @Log(title = "场站信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TSiteStationInfo tSiteStationInfo)
    {
        return toAjax(tSiteStationInfoService.insertTSiteStationInfo(tSiteStationInfo));
    }

    /**
     * 修改场站信息
     */
    //@PreAuthorize("@ss.hasPermi('baseInfo:station:edit')")
    @Log(title = "场站信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TSiteStationInfo tSiteStationInfo)
    {
        return toAjax(tSiteStationInfoService.updateTSiteStationInfo(tSiteStationInfo));
    }

    /**
     * 删除场站信息
     */
    //@PreAuthorize("@ss.hasPermi('baseInfo:station:remove')")
    @Log(title = "场站信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{siteStationIds}")
    public AjaxResult remove(@PathVariable Long[] siteStationIds)
    {
        return toAjax(tSiteStationInfoService.deleteTSiteStationInfoByIds(siteStationIds));
    }
}
