import request from '@/utils/request'

// 查询警告提醒列表
export function listInfo(query) {
  return request({
    url: '/warning/info/list',
    method: 'get',
    params: query
  })
}

// 查询警告提醒详细
export function getInfo(warningId) {
  return request({
    url: '/warning/info/' + warningId,
    method: 'get'
  })
}

// 新增警告提醒
export function addInfo(data) {
  return request({
    url: '/warning/info',
    method: 'post',
    data: data
  })
}

// 修改警告提醒
export function updateInfo(data) {
  return request({
    url: '/warning/info',
    method: 'put',
    data: data
  })
}

// 删除警告提醒
export function delInfo(warningId) {
  return request({
    url: '/warning/info/' + warningId,
    method: 'delete'
  })
}

// 导出警告提醒
export function exportInfo(query) {
  return request({
    url: '/warning/info/export',
    method: 'get',
    params: query
  })
}

//解除警告信息
export function freeWarningInfo(query) {
  return request({
    url: '/warning/info/freeWarningInfo',
    method: 'get',
    params: query
  })
}
