package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TWarningInfo;

/**
 * 警告提醒Service接口
 * 
 * @author zehong
 * @date 2024-09-05
 */
public interface ITWarningInfoService 
{
    /**
     * 查询警告提醒
     * 
     * @param warningId 警告提醒ID
     * @return 警告提醒
     */
    public TWarningInfo selectTWarningInfoById(Long warningId);

    /**
     * 查询警告提醒列表
     * 
     * @param tWarningInfo 警告提醒
     * @return 警告提醒集合
     */
    public List<TWarningInfo> selectTWarningInfoList(TWarningInfo tWarningInfo);

    /**
     * 新增警告提醒
     * 
     * @param tWarningInfo 警告提醒
     * @return 结果
     */
    public int insertTWarningInfo(TWarningInfo tWarningInfo);

    /**
     * 修改警告提醒
     * 
     * @param tWarningInfo 警告提醒
     * @return 结果
     */
    public int updateTWarningInfo(TWarningInfo tWarningInfo);

    /**
     * 批量删除警告提醒
     * 
     * @param warningIds 需要删除的警告提醒ID
     * @return 结果
     */
    public int deleteTWarningInfoByIds(Long[] warningIds);

    /**
     * 删除警告提醒信息
     * 
     * @param warningId 警告提醒ID
     * @return 结果
     */
    public int deleteTWarningInfoById(Long warningId);

    /**
     * 定时自动处理警告信息
     */
    void autoInsertWarningInfo();

    /**
     * 解除警报
     * @param warningId 警报主键
     * @return
     */
    int freeWarningInfo(Long warningId);
}
