package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 视频管理对象 t_video_manage
 * 
 * @author zehong
 * @date 2024-03-28
 */
public class TVideoManage extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 视频id */
    private Long videoId;

    /** 视频名称 */
    @Excel(name = "视频名称")
    private String videoName;

    /** 视频资源号 */
    @Excel(name = "视频资源号")
    private String videoResource;

    /** 是否删除(0正常，1删除) */
    private String isDel;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    public void setVideoId(Long videoId) 
    {
        this.videoId = videoId;
    }

    public Long getVideoId() 
    {
        return videoId;
    }
    public void setVideoName(String videoName) 
    {
        this.videoName = videoName;
    }

    public String getVideoName() 
    {
        return videoName;
    }
    public void setVideoResource(String videoResource) 
    {
        this.videoResource = videoResource;
    }

    public String getVideoResource() 
    {
        return videoResource;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("videoId", getVideoId())
            .append("videoName", getVideoName())
            .append("videoResource", getVideoResource())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("isDel", getIsDel())
            .append("remarks", getRemarks())
            .toString();
    }
}
