/*
 * @Author: 纪泽龙 jizelong@qq.com
 * @Date: 2023-03-15 13:49:30
 * @LastEditors: 纪泽龙 jizelong@qq.com
 * @LastEditTime: 2023-03-15 16:46:54
 * @FilePath: /danger-manage-web/src/utils/cesium/cesiumRoamStart.js
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */

export default class AroundPoint {
  constructor(viewer, amount, position, height, heading, pitch) {
    this._viewer = viewer;
    this._amount = amount;
    this._position = position;
    this.height = height;
    this.heading = heading;
    this.pitch = pitch;
  }

  _bindEvent() {
    this._viewer.clock.onTick.addEventListener(this._aroundPoint, this);
  }

  _unbindEvent() {
    this._viewer.camera.lookAtTransform(Cesium.Matrix4.IDENTITY);
    this._viewer.clock.onTick.removeEventListener(this._aroundPoint, this);
  }

  start() {
    this._viewer.clock.shouldAnimate = true;
    this._unbindEvent();
    this._bindEvent();
    return this;
  }

  stop() {
    this._unbindEvent();
    return this;
  }

  // 相机绕点旋转函数
  _aroundPoint() {
    let heading =  this._viewer.camera.heading;
    let pitch =  this._viewer.camera.pitch;

    // console.log(Cesium.Math.toRadians(this._amount))
    heading += Cesium.Math.toRadians(this._amount);
    if (heading >= Math.PI * 2 || heading <= -Math.PI * 2) {
      heading =  0
    }
    // 用新坐标替换旧坐标
    this.heading = heading;
    this.pitch = pitch;
    this._viewer.camera.lookAt(
      this._position,
      new Cesium.HeadingPitchRange(heading, pitch, this.height)
    );
  }
}
