import request from '@/utils/request'

// 查询地图打点列表
export function listMapdot(query) {
  return request({
    url: '/device/mapDot/list',
    method: 'get',
    params: query
  })
}

//不带分页地图打点
export function mapDotList(query) {
  return request({
    url: '/device/mapDot/mapDotList',
    method: 'get',
    params: query
  })
}

// 查询地图打点详细
export function getMapdot(id) {
  return request({
    url: '/device/mapDot/' + id,
    method: 'get'
  })
}

// 新增地图打点
export function addMapdot(data) {
  return request({
    url: '/device/mapDot',
    method: 'post',
    data: data
  })
}

// 修改地图打点
export function updateMapdot(data) {
  return request({
    url: '/device/mapDot',
    method: 'put',
    data: data
  })
}

// 删除地图打点
export function delMapdot(id) {
  return request({
    url: '/device/mapDot/' + id,
    method: 'delete'
  })
}

// 导出地图打点
export function exportMapdot(query) {
  return request({
    url: '/device/mapDot/export',
    method: 'get',
    params: query
  })
}
