package com.zehong.system.service.impl;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

import com.zehong.system.domain.TEmergencyDisposeStep;
import com.zehong.system.mapper.TEmergencyDisposeStepMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TEmergencyResponseMapper;
import com.zehong.system.domain.TEmergencyResponse;
import com.zehong.system.service.ITEmergencyResponseService;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;

/**
 * 应急响应Service业务层处理
 * 
 * @author zehong
 * @date 2024-09-06
 */
@Service
public class TEmergencyResponseServiceImpl implements ITEmergencyResponseService 
{
    @Autowired
    private TEmergencyResponseMapper tEmergencyResponseMapper;

    @Resource
    private TEmergencyDisposeStepMapper tEmergencyDisposeStepMapper;

    /**
     * 查询应急响应
     * 
     * @param responseId 应急响应ID
     * @return 应急响应
     */
    @Override
    public TEmergencyResponse selectTEmergencyResponseById(Long responseId)
    {
        return tEmergencyResponseMapper.selectTEmergencyResponseById(responseId);
    }

    /**
     * 查询应急响应列表
     * 
     * @param tEmergencyResponse 应急响应
     * @return 应急响应
     */
    @Override
    public List<TEmergencyResponse> selectTEmergencyResponseList(TEmergencyResponse tEmergencyResponse)
    {
        List<TEmergencyResponse> responseList = tEmergencyResponseMapper.selectTEmergencyResponseList(tEmergencyResponse);
        for(TEmergencyResponse response : responseList){
            TEmergencyDisposeStep step = new TEmergencyDisposeStep();
            step.setResponseId(response.getResponseId());
            List<TEmergencyDisposeStep> stepList = tEmergencyDisposeStepMapper.selectTEmergencyDisposeStepList(step);
            if(!CollectionUtils.isEmpty(stepList)){
                List<TEmergencyDisposeStep> stepListDesc =  stepList.stream().sorted(Comparator.comparing(TEmergencyDisposeStep::getDisposeTime).reversed()).collect(Collectors.toList());
                response.setNewStep(stepListDesc.get(0));
            }
        }
        return responseList;
    }

    /**
     * 新增应急响应
     * 
     * @param tEmergencyResponse 应急响应
     * @return 结果
     */
    @Override
    public int insertTEmergencyResponse(TEmergencyResponse tEmergencyResponse)
    {
        return tEmergencyResponseMapper.insertTEmergencyResponse(tEmergencyResponse);
    }

    /**
     * 修改应急响应
     * 
     * @param tEmergencyResponse 应急响应
     * @return 结果
     */
    @Override
    public int updateTEmergencyResponse(TEmergencyResponse tEmergencyResponse)
    {
        return tEmergencyResponseMapper.updateTEmergencyResponse(tEmergencyResponse);
    }

    /**
     * 批量删除应急响应
     * 
     * @param responseIds 需要删除的应急响应ID
     * @return 结果
     */
    @Override
    public int deleteTEmergencyResponseByIds(Long[] responseIds)
    {
        return tEmergencyResponseMapper.deleteTEmergencyResponseByIds(responseIds);
    }

    /**
     * 删除应急响应信息
     * 
     * @param responseId 应急响应ID
     * @return 结果
     */
    @Override
    public int deleteTEmergencyResponseById(Long responseId)
    {
        return tEmergencyResponseMapper.deleteTEmergencyResponseById(responseId);
    }
}
