package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TFailure;

/**
 * 事故台账Service接口
 * 
 * @author zehong
 * @date 2023-12-20
 */
public interface ITFailureService 
{
    /**
     * 查询事故台账
     * 
     * @param id 事故台账ID
     * @return 事故台账
     */
    public TFailure selectTFailureById(Long id);

    /**
     * 查询事故台账列表
     * 
     * @param tFailure 事故台账
     * @return 事故台账集合
     */
    public List<TFailure> selectTFailureList(TFailure tFailure);

    /**
     * 新增事故台账
     * 
     * @param tFailure 事故台账
     * @return 结果
     */
    public int insertTFailure(TFailure tFailure);

    /**
     * 修改事故台账
     * 
     * @param tFailure 事故台账
     * @return 结果
     */
    public int updateTFailure(TFailure tFailure);

    /**
     * 批量删除事故台账
     * 
     * @param ids 需要删除的事故台账ID
     * @return 结果
     */
    public int deleteTFailureByIds(Long[] ids);

    /**
     * 删除事故台账信息
     * 
     * @param id 事故台账ID
     * @return 结果
     */
    public int deleteTFailureById(Long id);
}
