package com.zehong.system.mapper;

import java.time.Instant;
import java.util.List;
import com.zehong.system.domain.TDanger;
import org.apache.ibatis.annotations.Param;

/**
 * 安检隐患整改Mapper接口
 * 
 * @author zehong
 * @date 2023-11-09
 */
public interface TDangerMapper 
{
    /**
     * 查询安检隐患整改
     * 
     * @param id 安检隐患整改ID
     * @return 安检隐患整改
     */
    public TDanger selectTDangerById(Long id);

    /**
     * 查询安检隐患整改列表
     * 
     * @param tDanger 安检隐患整改
     * @return 安检隐患整改集合
     */
    public List<TDanger> selectTDangerList(TDanger tDanger);

    /**
     * 新增安检隐患整改
     * 
     * @param tDanger 安检隐患整改
     * @return 结果
     */
    public int insertTDanger(TDanger tDanger);

    /**
     * 修改安检隐患整改
     * 
     * @param tDanger 安检隐患整改
     * @return 结果
     */
    public int updateTDanger(TDanger tDanger);

    /**
     * 删除安检隐患整改
     * 
     * @param id 安检隐患整改ID
     * @return 结果
     */
    public int deleteTDangerById(Long id);

    /**
     * 批量删除安检隐患整改
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    public int deleteTDangerByIds(Long[] ids);


    public int deleteTDangerByInspectt(@Param("inspectId") Long inspectId , @Param("type")Integer type);
    public int updateByInspect(@Param("inspectId") Long inspectId , @Param("type")Integer type);
}
