package com.zehong.system.domain;

import java.math.BigDecimal;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 第三方施工对象 t_third_build
 * 
 * @author zehong
 * @date 2023-12-22
 */
public class TThirdBuild extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 工程名称 */
    @Excel(name = "工程名称")
    private String title;

    /** 申报单位 */
    @Excel(name = "申报单位")
    private String company;

    @Excel(name = "联系人")
    private String username;

    @Excel(name = "联系电话")
    private String phone;

    /** 经度 */
    @Excel(name = "经度")
    private BigDecimal longitude;

    /** 纬度 */
    @Excel(name = "纬度")
    private BigDecimal latitude;

    /** 详细地址 */
    @Excel(name = "详细地址")
    private String address;

    /** 开工日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "开工日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date startTime;

    /** 竣工日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "竣工日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date endTime;

    /** 安全告知书图片 */
    @Excel(name = "安全告知书图片")
    private String noticeUrl;

    /** 管道安全保护协议图片 */
    @Excel(name = "管道安全保护协议图片")
    private String protectUrl;

    /** 监护协议图片 */
    @Excel(name = "监护协议图片")
    private String custodyUrl;

    /** 管道现场安全技术交底图片 */
    @Excel(name = "管道现场安全技术交底图片")
    private String discloseUrl;

    /** 施工验收图片 */
    @Excel(name = "施工验收图片")
    private String checkUrl;

    /** 施工状态 0进行中 1已结束 */
    @Excel(name = "施工状态",readConverterExp = "0=进行中,1=已结束")
    private Integer status;

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setTitle(String title) 
    {
        this.title = title;
    }

    public String getTitle() 
    {
        return title;
    }
    public void setLongitude(BigDecimal longitude) 
    {
        this.longitude = longitude;
    }

    public BigDecimal getLongitude() 
    {
        return longitude;
    }
    public void setLatitude(BigDecimal latitude) 
    {
        this.latitude = latitude;
    }

    public BigDecimal getLatitude() 
    {
        return latitude;
    }
    public void setAddress(String address) 
    {
        this.address = address;
    }

    public String getAddress() 
    {
        return address;
    }
    public void setStartTime(Date startTime) 
    {
        this.startTime = startTime;
    }

    public Date getStartTime() 
    {
        return startTime;
    }
    public void setEndTime(Date endTime) 
    {
        this.endTime = endTime;
    }

    public Date getEndTime() 
    {
        return endTime;
    }
    public void setNoticeUrl(String noticeUrl) 
    {
        this.noticeUrl = noticeUrl;
    }

    public String getNoticeUrl() 
    {
        return noticeUrl;
    }
    public void setProtectUrl(String protectUrl) 
    {
        this.protectUrl = protectUrl;
    }

    public String getProtectUrl() 
    {
        return protectUrl;
    }
    public void setCustodyUrl(String custodyUrl) 
    {
        this.custodyUrl = custodyUrl;
    }

    public String getCustodyUrl() 
    {
        return custodyUrl;
    }
    public void setDiscloseUrl(String discloseUrl) 
    {
        this.discloseUrl = discloseUrl;
    }

    public String getDiscloseUrl() 
    {
        return discloseUrl;
    }
    public void setCheckUrl(String checkUrl) 
    {
        this.checkUrl = checkUrl;
    }

    public String getCheckUrl() 
    {
        return checkUrl;
    }
    public void setStatus(Integer status) 
    {
        this.status = status;
    }

    public Integer getStatus() 
    {
        return status;
    }

    public void setCompany(String company)
    {
        this.company = company;
    }

    public String getCompany()
    {
        return company;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("title", getTitle())
            .append("longitude", getLongitude())
            .append("latitude", getLatitude())
            .append("address", getAddress())
            .append("startTime", getStartTime())
            .append("endTime", getEndTime())
            .append("noticeUrl", getNoticeUrl())
            .append("protectUrl", getProtectUrl())
            .append("custodyUrl", getCustodyUrl())
            .append("discloseUrl", getDiscloseUrl())
            .append("checkUrl", getCheckUrl())
            .append("status", getStatus())
            .append("remark", getRemark())
            .append("createTime", getCreateTime())
            .toString();
    }
}
