package com.zehong.system.domain;

import java.math.BigDecimal;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 地图打点对象 t_mapdot
 * 
 * @author zehong
 * @date 2024-01-17
 */
public class TMapDot extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 点名称 */
    @Excel(name = "点名称")
    private String title;

    /** 经度 */
    @Excel(name = "经度")
    private BigDecimal longitude;

    /** 纬度 */
    @Excel(name = "纬度")
    private BigDecimal latitude;

    /** 点类型，1.调压箱，2.阀门井，3.管线，4.定向钻，5.大开挖，6.直埋 */
    @Excel(name = "点类型，1.调压箱，2.阀门井，3.管线，4.定向钻，5.大开挖，6.直埋")
    private Integer type;

    /** 压力等级，1是高压10Mpa，2是高压4Mpa，3是中压0.4Mpa */
    @Excel(name = "压力等级，1是高压10Mpa，2是高压4Mpa，3是中压0.4Mpa")
    private Integer pressure;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setTitle(String title) 
    {
        this.title = title;
    }

    public String getTitle() 
    {
        return title;
    }
    public void setLongitude(BigDecimal longitude) 
    {
        this.longitude = longitude;
    }

    public BigDecimal getLongitude() 
    {
        return longitude;
    }
    public void setLatitude(BigDecimal latitude) 
    {
        this.latitude = latitude;
    }

    public BigDecimal getLatitude() 
    {
        return latitude;
    }
    public void setType(Integer type) 
    {
        this.type = type;
    }

    public Integer getType() 
    {
        return type;
    }

    public Integer getPressure() {
        return pressure;
    }

    public void setPressure(Integer pressure) {
        this.pressure = pressure;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("title", getTitle())
            .append("longitude", getLongitude())
            .append("latitude", getLatitude())
            .append("type", getType())
            .append("remark", getRemark())
            .append("createTime", getCreateTime())
            .toString();
    }
}
