package com.zehong.web.controller.thirdbuild;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TThirdBuild;
import com.zehong.system.service.ITThirdBuildService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 第三方施工Controller
 * 
 * @author zehong
 * @date 2023-12-22
 */
@RestController
@RequestMapping("/third/build")
public class TThirdBuildController extends BaseController
{
    @Autowired
    private ITThirdBuildService tThirdBuildService;

    /**
     * 查询第三方施工列表
     */
    //@PreAuthorize("@ss.hasPermi('third:build:list')")
    @GetMapping("/list")
    public TableDataInfo list(TThirdBuild tThirdBuild)
    {
        startPage();
        List<TThirdBuild> list = tThirdBuildService.selectTThirdBuildList(tThirdBuild);
        return getDataTable(list);
    }

    /**
     * 导出第三方施工列表
     */
    //@PreAuthorize("@ss.hasPermi('third:build:export')")
    @Log(title = "第三方施工", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TThirdBuild tThirdBuild)
    {
        List<TThirdBuild> list = tThirdBuildService.selectTThirdBuildList(tThirdBuild);
        ExcelUtil<TThirdBuild> util = new ExcelUtil<TThirdBuild>(TThirdBuild.class);
        return util.exportExcel(list, "第三方施工数据");
    }

    /**
     * 获取第三方施工详细信息
     */
    //@PreAuthorize("@ss.hasPermi('third:build:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tThirdBuildService.selectTThirdBuildById(id));
    }

    /**
     * 新增第三方施工
     */
    //@PreAuthorize("@ss.hasPermi('third:build:add')")
    @Log(title = "第三方施工", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TThirdBuild tThirdBuild)
    {
        return toAjax(tThirdBuildService.insertTThirdBuild(tThirdBuild));
    }

    /**
     * 修改第三方施工
     */
    //@PreAuthorize("@ss.hasPermi('third:build:edit')")
    @Log(title = "第三方施工", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TThirdBuild tThirdBuild)
    {
        return toAjax(tThirdBuildService.updateTThirdBuild(tThirdBuild));
    }

    /**
     * 删除第三方施工
     */
    //@PreAuthorize("@ss.hasPermi('third:build:remove')")
    @Log(title = "第三方施工", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tThirdBuildService.deleteTThirdBuildByIds(ids));
    }
}
