package com.zehong.web.controller.pipetask;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TPipeTaskUser;
import com.zehong.system.service.ITPipeTaskUserService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 管线巡检起止Controller
 * 
 * @author zehong
 * @date 2023-11-17
 */
@RestController
@RequestMapping("/system/pipetaskuser")
public class TPipeTaskUserController extends BaseController
{
    @Autowired
    private ITPipeTaskUserService tPipeTaskUserService;

    /**
     * 查询管线巡检起止列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TPipeTaskUser tPipeTaskUser)
    {
        startPage();
        List<TPipeTaskUser> list = tPipeTaskUserService.selectTPipeTaskUserList(tPipeTaskUser);
        return getDataTable(list);
    }

    /**
     * 导出管线巡检起止列表
     */
    @Log(title = "管线巡检起止", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TPipeTaskUser tPipeTaskUser)
    {
        List<TPipeTaskUser> list = tPipeTaskUserService.selectTPipeTaskUserList(tPipeTaskUser);
        ExcelUtil<TPipeTaskUser> util = new ExcelUtil<TPipeTaskUser>(TPipeTaskUser.class);
        return util.exportExcel(list, "管线巡检起止数据");
    }

    /**
     * 获取管线巡检起止详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tPipeTaskUserService.selectTPipeTaskUserById(id));
    }

    /**
     * 新增管线巡检起止
     */
    @Log(title = "管线巡检起止", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TPipeTaskUser tPipeTaskUser)
    {
        return toAjax(tPipeTaskUserService.insertTPipeTaskUser(tPipeTaskUser));
    }

    /**
     * 开始结束巡检
     * @param tPipeTaskUser
     * @return
     */
    @PostMapping("/updateStatus")
    public AjaxResult updateStatus(@RequestBody TPipeTaskUser tPipeTaskUser)
    {
        return toAjax(tPipeTaskUserService.updateStatus(tPipeTaskUser));
    }

    /**
     * 修改管线巡检起止
     */
    @Log(title = "管线巡检起止", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TPipeTaskUser tPipeTaskUser)
    {
        return toAjax(tPipeTaskUserService.updateTPipeTaskUser(tPipeTaskUser));
    }

    /**
     * 删除管线巡检起止
     */
    @Log(title = "管线巡检起止", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tPipeTaskUserService.deleteTPipeTaskUserByIds(ids));
    }
}
