package com.zehong.web.controller.checktask;

import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.enums.BusinessType;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.TInspectStatisticsInfo;
import com.zehong.system.domain.TTask;
import com.zehong.system.domain.TTaskInspect;
import com.zehong.system.domain.TTaskInspectExport;
import com.zehong.system.domain.vo.*;
import com.zehong.system.service.ITStatisticsInspectItemService;
import com.zehong.system.service.ITTaskInspectExportService;
import com.zehong.system.service.ITTaskInspectService;
import com.zehong.system.service.ITTaskService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 安检任务执行Controller
 * 
 * @author zehong
 * @date 2023-11-07
 */
@RestController
@RequestMapping("/checktask/inspect")
public class TTaskInspectController extends BaseController
{
    @Autowired
    private ITTaskInspectService tTaskInspectService;
    @Autowired
    private ITTaskService taskService;
    @Autowired
    private ITTaskInspectExportService taskInspectExportService;
    @Autowired
    private ITStatisticsInspectItemService itStatisticsInspectItemService;

    /**
     * 查询安检任务执行列表
     */
    //@PreAuthorize("@ss.hasPermi('checktask:inspect:list')")
    @GetMapping("/list")
    public TableDataInfo list(TTaskInspect tTaskInspect)
    {
        startPage();
        List<TTaskInspect> list = tTaskInspectService.selectTTaskInspectList(tTaskInspect);
        return getDataTable(list);
    }
    @GetMapping("/juminlist")
    public TableDataInfo juminlist(TTaskInspect tTaskInspect)
    {
        startPage();
        List<TTaskInspect> list = tTaskInspectService.selectJuminInspectList(tTaskInspect);
        return getDataTable(list);
    }

    /**
     * 查询是否有未完成的安检单
     * @param tTaskInspect
     * @return
     */
    @GetMapping("/incomplete")
    public AjaxResult incomplete(TTaskInspect tTaskInspect)
    {
        TTaskInspect inspect = tTaskInspectService.selectBytaskIduserId(tTaskInspect);
        return AjaxResult.success(inspect);
    }
    /**
     * 居民用户安检任务执行
     * @return
     */
    @GetMapping("/jmlist")
    public TableDataInfo selectJMinspect(UserTaskInspect userTaskInspect)
    {
        startPage();
        List<UserTaskInspect> list = tTaskInspectService.selectJMinspect(userTaskInspect);
        return getDataTable(list);
    }

    /**
     * 餐饮用户安检任务执行
     * @param userTaskInspect
     * @return
     */
    @GetMapping("/cylist")
    public TableDataInfo selectCYinspect(UserTaskInspect userTaskInspect)
    {
        startPage();
        List<UserTaskInspect> list = tTaskInspectService.selectCYinspect(userTaskInspect);
        return getDataTable(list);
    }

    /**
     * 导出安检任务执行列表
     */
    //@PreAuthorize("@ss.hasPermi('checktask:inspect:export')")
    @Log(title = "安检任务执行", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TTaskInspect tTaskInspect)
    {
        List<TTaskInspect> list = tTaskInspectService.selectTTaskInspectList(tTaskInspect);
        ExcelUtil<TTaskInspect> util = new ExcelUtil<TTaskInspect>(TTaskInspect.class);
        return util.exportExcel(list, "安检任务执行数据");
    }

    /**
     * 居民安检导出
     * @param userTaskInspect
     * @return
     */
    @GetMapping("/jmInspectExport")
    public AjaxResult jmInspectExport(UserTaskInspect userTaskInspect){
        List<UserTaskInspect> list = tTaskInspectService.selectJMinspect(userTaskInspect);
        ExcelUtil<UserTaskInspect> util = new ExcelUtil<>(UserTaskInspect.class);
        return util.exportExcel(list, "居民安检任务数据");
    }

    /**
     * 获取安检任务执行详细信息
     */
    //@PreAuthorize("@ss.hasPermi('checktask:inspect:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tTaskInspectService.selectTTaskInspectById(id));
    }

    @GetMapping(value = "inspectInfo/{id}")
    public AjaxResult getInspectInfo(@PathVariable("id") Long id){
        return AjaxResult.success(tTaskInspectService.selectTTaskInspectById(id));
    }

    /**
     * 新增安检任务执行
     */
    //@PreAuthorize("@ss.hasPermi('checktask:inspect:add')")
    @Log(title = "安检任务执行", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TTaskInspect tTaskInspect)
    {
        int a = tTaskInspectService.insertTTaskInspect(tTaskInspect);
        return AjaxResult.success(tTaskInspect.getId());
    }

    /**
     * 修改安检任务执行
     */
    //@PreAuthorize("@ss.hasPermi('checktask:inspect:edit')")
    @Log(title = "安检任务执行", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TTaskInspect tTaskInspect)
    {
        return toAjax(tTaskInspectService.updateTTaskInspect(tTaskInspect));
    }

    /**
     * 删除安检任务执行
     */
    //@PreAuthorize("@ss.hasPermi('checktask:inspect:remove')")
    @Log(title = "安检任务执行", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tTaskInspectService.deleteTTaskInspectByIds(ids));
    }

    /**
     * 安检任务统计
     * @param tTaskInspect 安检实体
     * @return
     */
    @GetMapping("/taskInspectStatistics")
    public AjaxResult taskInspectStatistics(TTaskInspect tTaskInspect){
        return AjaxResult.success(tTaskInspectService.taskInspectStatistics(tTaskInspect));
    }

    /**
     *
     * @param userTaskInspect
     * @return
     */
    @GetMapping("/anjiandetaillist")
    public TableDataInfo anjiandetaillist(Userinstpect userinstpect)
    {
        TTask task = taskService.selectTTaskById(userinstpect.getTaskId());
        userinstpect.setType(task.getType().intValue());
        userinstpect.setTaskType(task.getTaskType());
        startPage();
        List<Userinstpect> list = tTaskInspectService.anjiandetaillist(userinstpect);
        return getDataTable(list);
    }


    @GetMapping("/exportInspectZip")
    public AjaxResult exportInspectZip(TTaskInspectExport export) {
        return AjaxResult.success(taskInspectExportService.exportInspectZip(export));
    }

    /**
     * 到访不遇查询
     * @param userTaskInspect
     * @return
     */
    @GetMapping("/selectVisitorMissInfo")
    public TableDataInfo selectVisitorMissInfo (UserTaskInspect userTaskInspect){
        startPage();
        return getDataTable(tTaskInspectService.selectVisitorMissInfo(userTaskInspect));
    }

    @GetMapping("/visitorMissInfoExport")
    public AjaxResult visitorMissInfoExport(UserTaskInspect userTaskInspect) {
        List<UserTaskInspect> list = tTaskInspectService.selectVisitorMissInfo(userTaskInspect);
        if("1".equals( userTaskInspect.getBtype())){
            List<UserVisitorMissInfoExport> userInspectExportList = new ArrayList<>();
            for(UserTaskInspect inspect : list){
                UserVisitorMissInfoExport userInspectExport = new UserVisitorMissInfoExport();
                BeanUtils.copyProperties(inspect,userInspectExport);
                userInspectExportList.add(userInspectExport);
            }
            ExcelUtil<UserVisitorMissInfoExport> util = new ExcelUtil<>(UserVisitorMissInfoExport.class);
            return util.exportExcel(userInspectExportList, "到访不遇数据");

        }else if("2".equals( userTaskInspect.getBtype())){
            List<BusinessVisitorMissInfoExport> businessVisitorMissInfoExportList = new ArrayList<>();
            for(UserTaskInspect inspect : list){
                BusinessVisitorMissInfoExport businessVisitorMissInfoExport = new BusinessVisitorMissInfoExport();
                BeanUtils.copyProperties(inspect,businessVisitorMissInfoExport);
                businessVisitorMissInfoExportList.add(businessVisitorMissInfoExport);
            }
            ExcelUtil<BusinessVisitorMissInfoExport> util = new ExcelUtil<>(BusinessVisitorMissInfoExport.class);
            return util.exportExcel(businessVisitorMissInfoExportList, "到访不遇数据");
        }else{
            List<IndustryVisitorMissInfoExport> industryVisitorMissInfoExportList = new ArrayList<>();
            for(UserTaskInspect inspect : list){
                IndustryVisitorMissInfoExport industryVisitorMissInfoExport = new IndustryVisitorMissInfoExport();
                BeanUtils.copyProperties(inspect,industryVisitorMissInfoExport);
                industryVisitorMissInfoExportList.add(industryVisitorMissInfoExport);
            }
            ExcelUtil<IndustryVisitorMissInfoExport> util = new ExcelUtil<>(IndustryVisitorMissInfoExport.class);
            return util.exportExcel(industryVisitorMissInfoExportList, "到访不遇数据");
        }
    }

    /**
     * 任务检查项统计
     * @param inspectStatisticsInfo 统计条件
     * @return
     */
    @GetMapping("/statisticsInspectItems")
    public AjaxResult statisticsInspectItems(TInspectStatisticsInfo inspectStatisticsInfo){
        return AjaxResult.success(itStatisticsInspectItemService.statisticsInspectItems(inspectStatisticsInfo));
    }
}
