package com.zehong.web.controller.checktask;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.zehong.common.core.domain.model.LoginUser;
import com.zehong.common.utils.ServletUtils;
import com.zehong.common.utils.StringUtils;
import com.zehong.framework.web.service.TokenService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TTask;
import com.zehong.system.service.ITTaskService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 入户安检任务Controller
 * 
 * @author zehong
 * @date 2023-11-06
 */
@RestController
@RequestMapping("/checktask/task")
public class TTaskController extends BaseController
{
    @Autowired
    private ITTaskService tTaskService;
    @Autowired
    private TokenService tokenService;

    /**
     * 查询入户安检任务列表
     */
    //@PreAuthorize("@ss.hasPermi('checktask:task:list')")
    @GetMapping("/list")
    public TableDataInfo list(TTask tTask)
    {
        startPage();
        List<TTask> list = tTaskService.selectTTaskList(tTask);
        return getDataTable(list);
    }

    /**
     * 所有任务信息
     * @param tTask 入参
     * @return
     */
    @GetMapping("/taskInfoList")
    public AjaxResult taskInfoList(TTask tTask){
        return AjaxResult.success( tTaskService.selectTTaskList(tTask));
    }

    /**
     * 导出入户安检任务列表
     */
    //@PreAuthorize("@ss.hasPermi('checktask:task:export')")
    @Log(title = "入户安检任务", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TTask tTask)
    {
        List<TTask> list = tTaskService.selectTTaskList(tTask);
        ExcelUtil<TTask> util = new ExcelUtil<TTask>(TTask.class);
        return util.exportExcel(list, "入户安检任务数据");
    }

    /**
     * 小程序r任务列表
     * @param tTask
     * @return
     */
    @GetMapping("/selecttasknums")
    public TableDataInfo selecttasknums(TTask tTask)
    {
        startPage();
        List<TTask> list = tTaskService.selecttasknums(tTask);
        return getDataTable(list);
    }
    /**
     * 获取入户安检任务详细信息
     */
    //@PreAuthorize("@ss.hasPermi('checktask:task:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tTaskService.selectTTaskById(id));
    }

    /**
     * 新增入户安检任务
     */
    //@PreAuthorize("@ss.hasPermi('checktask:task:add')")
    @Log(title = "入户安检任务", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TTask tTask)
    {
        LoginUser loginUser = tokenService.getLoginUser(ServletUtils.getRequest());
        Long userId = loginUser.getUser().getUserId();
        tTask.setAdminId(userId);
        return toAjax(tTaskService.insertTTask(tTask));
    }

    /**
     * 修改入户安检任务
     */
    //@PreAuthorize("@ss.hasPermi('checktask:task:edit')")
    @Log(title = "入户安检任务", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TTask tTask)
    {
        return toAjax(tTaskService.updateTTask(tTask));
    }

    /**
     * 删除入户安检任务
     */
    //@PreAuthorize("@ss.hasPermi('checktask:task:remove')")
    @Log(title = "入户安检任务", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tTaskService.deleteTTaskByIds(ids));
    }

    /**
     * 根据任务类型获取最新任务
     * @param type 任务类型
     * @param checkType 工业安检类型
     * @param taskType 居民用户安检类型
     * @return
     */
    @GetMapping("/selectCurrentTaskByType")
    public AjaxResult selectCurrentTaskByType(@RequestParam(value="type") Integer type,@RequestParam(value="checkType",required = false) Integer checkType,@RequestParam(value="taskType",required = false) Integer taskType){
        Map<String,Object> param = new HashMap<>();
        param.put("type",type);
        param.put("checkType",checkType);
        param.put("taskType",taskType);
        return AjaxResult.success(tTaskService.selectCurrentTaskByType(param));
     }

    /**
     * 任务详情 任务统计
     * @param taskId 任务主键
     * @return
     */
    @GetMapping("/taskDetailInfo")
    public AjaxResult taskDetailInfo(@RequestParam(value="taskId") Long taskId){
        return AjaxResult.success(tTaskService.taskDetailInfo(taskId));
    }

    /**
     * 任务详情任务进度统计
     * @param taskId 任务主键
     * @param type 任务类型
     * @param taskType 居民用户安检类型
     * @return
     */
    @GetMapping("/taskInspectDetailInfo")
    public AjaxResult taskInspectDetailInfo(@RequestParam(value = "taskId") Long taskId,@RequestParam(value = "type") int type,@RequestParam(value = "taskType",required = false) String taskType){
        Map<String,Object> param = new HashMap<>();
        param.put("taskId",taskId);
        param.put("type",type);
        if(StringUtils.isNotEmpty(taskType)) param.put("taskType",taskType);
        return AjaxResult.success(tTaskService.taskInspectDetailInfo(param));
    }

    /**
     * 任务详情隐患统计
     * @param taskId 任务主键
     * @return
     */
    @GetMapping("/taskInspectDangerDetailInfo")
    public AjaxResult taskInspectDangerDetailInfo(Long taskId){
        return AjaxResult.success(tTaskService.taskInspectDangerDetailInfo(taskId));
    }
}
