package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TVideoManage;

/**
 * 视频管理Service接口
 * 
 * @author zehong
 * @date 2024-03-28
 */
public interface ITVideoManageService 
{
    /**
     * 查询视频管理
     * 
     * @param videoId 视频管理ID
     * @return 视频管理
     */
    public TVideoManage selectTVideoManageById(Long videoId);

    /**
     * 查询视频管理列表
     * 
     * @param tVideoManage 视频管理
     * @return 视频管理集合
     */
    public List<TVideoManage> selectTVideoManageList(TVideoManage tVideoManage);

    /**
     * 新增视频管理
     * 
     * @param tVideoManage 视频管理
     * @return 结果
     */
    public int insertTVideoManage(TVideoManage tVideoManage);

    /**
     * 修改视频管理
     * 
     * @param tVideoManage 视频管理
     * @return 结果
     */
    public int updateTVideoManage(TVideoManage tVideoManage);

    /**
     * 批量删除视频管理
     * 
     * @param videoIds 需要删除的视频管理ID
     * @return 结果
     */
    public int deleteTVideoManageByIds(Long[] videoIds);

    /**
     * 删除视频管理信息
     * 
     * @param videoId 视频管理ID
     * @return 结果
     */
    public int deleteTVideoManageById(Long videoId);
}
