package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TCommunity;

/**
 * 居民小区（村）Service接口
 * 
 * @author zehong
 * @date 2023-11-03
 */
public interface ITCommunityService 
{
    /**
     * 查询居民小区（村）
     * 
     * @param id 居民小区（村）ID
     * @return 居民小区（村）
     */
    public TCommunity selectTCommunityById(Long id);

    /**
     * 查询居民小区（村）列表
     * 
     * @param tCommunity 居民小区（村）
     * @return 居民小区（村）集合
     */
    public List<TCommunity> selectTCommunityList(TCommunity tCommunity);

    /**
     * 新增居民小区（村）
     * 
     * @param tCommunity 居民小区（村）
     * @return 结果
     */
    public int insertTCommunity(TCommunity tCommunity);

    /**
     * 修改居民小区（村）
     * 
     * @param tCommunity 居民小区（村）
     * @return 结果
     */
    public int updateTCommunity(TCommunity tCommunity);

    /**
     * 批量删除居民小区（村）
     * 
     * @param ids 需要删除的居民小区（村）ID
     * @return 结果
     */
    public int deleteTCommunityByIds(Long[] ids);

    /**
     * 删除居民小区（村）信息
     * 
     * @param id 居民小区（村）ID
     * @return 结果
     */
    public int deleteTCommunityById(Long id);
}
