import request from '@/utils/request'

// 查询视频管理列表
export function listManage(query) {
  return request({
    url: '/video/manage/list',
    method: 'get',
    params: query
  })
}

//视频数据未分页
export function videoInfoList(query) {
  return request({
    url: '/video/manage/videoInfoList',
    method: 'get',
    params: query
  })
}

// 查询视频管理详细
export function getManage(videoId) {
  return request({
    url: '/video/manage/' + videoId,
    method: 'get'
  })
}

// 新增视频管理
export function addManage(data) {
  return request({
    url: '/video/manage',
    method: 'post',
    data: data
  })
}

// 修改视频管理
export function updateManage(data) {
  return request({
    url: '/video/manage',
    method: 'put',
    data: data
  })
}

// 删除视频管理
export function delManage(videoId) {
  return request({
    url: '/video/manage/' + videoId,
    method: 'delete'
  })
}

// 导出视频管理
export function exportManage(query) {
  return request({
    url: '/video/manage/export',
    method: 'get',
    params: query
  })
}
