import request from '@/utils/request'

// 查询第三方施工列表
export function listBuild(query) {
  return request({
    url: '/third/build/list',
    method: 'get',
    params: query
  })
}

// 查询第三方施工详细
export function getBuild(id) {
  return request({
    url: '/third/build/' + id,
    method: 'get'
  })
}

// 新增第三方施工
export function addBuild(data) {
  return request({
    url: '/third/build',
    method: 'post',
    data: data
  })
}

// 修改第三方施工
export function updateBuild(data) {
  return request({
    url: '/third/build',
    method: 'put',
    data: data
  })
}

// 删除第三方施工
export function delBuild(id) {
  return request({
    url: '/third/build/' + id,
    method: 'delete'
  })
}

// 导出第三方施工
export function exportBuild(query) {
  return request({
    url: '/third/build/export',
    method: 'get',
    params: query
  })
}
