import request from '@/utils/request'

// 查询应急响应列表
export function listResponse(query) {
  return request({
    url: '/emergency/response/list',
    method: 'get',
    params: query
  })
}

//应急响应列表
export function emergencyResponseList(query) {
  return request({
    url: '/emergency/response/emergencyResponseList',
    method: 'get',
    params: query
  })
}

// 查询应急响应详细
export function getResponse(responseId) {
  return request({
    url: '/emergency/response/' + responseId,
    method: 'get'
  })
}

// 新增应急响应
export function addResponse(data) {
  return request({
    url: '/emergency/response',
    method: 'post',
    data: data
  })
}

// 修改应急响应
export function updateResponse(data) {
  return request({
    url: '/emergency/response',
    method: 'put',
    data: data
  })
}

// 删除应急响应
export function delResponse(responseId) {
  return request({
    url: '/emergency/response/' + responseId,
    method: 'delete'
  })
}

// 导出应急响应
export function exportResponse(query) {
  return request({
    url: '/emergency/response/export',
    method: 'get',
    params: query
  })
}
