import request from '@/utils/request'

// 查询应急报警列表
export function listInfo(query) {
  return request({
    url: '/emergency/alarm/list',
    method: 'get',
    params: query
  })
}

// 查询应急报警详细
export function getInfo(id) {
  return request({
    url: '/emergency/alarm/' + id,
    method: 'get'
  })
}

// 新增应急报警
export function addInfo(data) {
  return request({
    url: '/emergency/alarm',
    method: 'post',
    data: data
  })
}

// 修改应急报警
export function updateInfo(data) {
  return request({
    url: '/emergency/alarm',
    method: 'put',
    data: data
  })
}

// 删除应急报警
export function delInfo(id) {
  return request({
    url: '/emergency/alarm/' + id,
    method: 'delete'
  })
}

// 导出应急报警
export function exportInfo(query) {
  return request({
    url: '/emergency/alarm/export',
    method: 'get',
    params: query
  })
}
