import request from '@/utils/request'

// 查询设备信息列表
export function listInfo(query) {
  return request({
    url: '/baseInfo/device/list',
    method: 'get',
    params: query
  })
}

//查询所有设备信息
export function deviceInfoList(query) {
  return request({
    url: '/baseInfo/device/deviceInfoList',
    method: 'get',
    params: query
  })
}

// 查询设备信息详细
export function getInfo(deviceId) {
  return request({
    url: '/baseInfo/device/' + deviceId,
    method: 'get'
  })
}

// 新增设备信息
export function addInfo(data) {
  return request({
    url: '/baseInfo/device',
    method: 'post',
    data: data
  })
}

// 修改设备信息
export function updateInfo(data) {
  return request({
    url: '/baseInfo/device',
    method: 'put',
    data: data
  })
}

// 删除设备信息
export function delInfo(deviceId) {
  return request({
    url: '/baseInfo/device/' + deviceId,
    method: 'delete'
  })
}

// 导出设备信息
export function exportInfo(query) {
  return request({
    url: '/baseInfo/device/export',
    method: 'get',
    params: query
  })
}
