import request from '@/utils/request'

// 查询工商业用户列表
export function listBusiness(query) {
  return request({
    url: '/baseInfo/business/list',
    method: 'get',
    params: query
  })
}

// 查询工商业用户详细
export function getBusiness(id) {
  return request({
    url: '/baseInfo/business/' + id,
    method: 'get'
  })
}

// 新增工商业用户
export function addBusiness(data) {
  return request({
    url: '/baseInfo/business',
    method: 'post',
    data: data
  })
}

// 修改工商业用户
export function updateBusiness(data) {
  return request({
    url: '/baseInfo/business',
    method: 'put',
    data: data
  })
}

// 删除工商业用户
export function delBusiness(id) {
  return request({
    url: '/baseInfo/business/' + id,
    method: 'delete'
  })
}

// 导出工商业用户
export function exportBusiness(query) {
  return request({
    url: '/baseInfo/business/export',
    method: 'get',
    params: query
  })
}
