package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TThirdBuildInspectMapper;
import com.zehong.system.domain.TThirdBuildInspect;
import com.zehong.system.service.ITThirdBuildInspectService;

/**
 * 第三方施工执行Service业务层处理
 * 
 * @author zehong
 * @date 2023-12-22
 */
@Service
public class TThirdBuildInspectServiceImpl implements ITThirdBuildInspectService 
{
    @Autowired
    private TThirdBuildInspectMapper tThirdBuildInspectMapper;

    /**
     * 查询第三方施工执行
     * 
     * @param id 第三方施工执行ID
     * @return 第三方施工执行
     */
    @Override
    public TThirdBuildInspect selectTThirdBuildInspectById(Long id)
    {
        return tThirdBuildInspectMapper.selectTThirdBuildInspectById(id);
    }

    /**
     * 查询第三方施工执行列表
     * 
     * @param tThirdBuildInspect 第三方施工执行
     * @return 第三方施工执行
     */
    @Override
    public List<TThirdBuildInspect> selectTThirdBuildInspectList(TThirdBuildInspect tThirdBuildInspect)
    {
        return tThirdBuildInspectMapper.selectTThirdBuildInspectList(tThirdBuildInspect);
    }

    /**
     * 新增第三方施工执行
     * 
     * @param tThirdBuildInspect 第三方施工执行
     * @return 结果
     */
    @Override
    public int insertTThirdBuildInspect(TThirdBuildInspect tThirdBuildInspect)
    {
        if(tThirdBuildInspect.getCreateTime()==null){
            tThirdBuildInspect.setCreateTime(DateUtils.getNowDate());
        }
        return tThirdBuildInspectMapper.insertTThirdBuildInspect(tThirdBuildInspect);
    }

    /**
     * 修改第三方施工执行
     * 
     * @param tThirdBuildInspect 第三方施工执行
     * @return 结果
     */
    @Override
    public int updateTThirdBuildInspect(TThirdBuildInspect tThirdBuildInspect)
    {
        return tThirdBuildInspectMapper.updateTThirdBuildInspect(tThirdBuildInspect);
    }

    /**
     * 批量删除第三方施工执行
     * 
     * @param ids 需要删除的第三方施工执行ID
     * @return 结果
     */
    @Override
    public int deleteTThirdBuildInspectByIds(Long[] ids)
    {
        return tThirdBuildInspectMapper.deleteTThirdBuildInspectByIds(ids);
    }

    /**
     * 删除第三方施工执行信息
     * 
     * @param id 第三方施工执行ID
     * @return 结果
     */
    @Override
    public int deleteTThirdBuildInspectById(Long id)
    {
        return tThirdBuildInspectMapper.deleteTThirdBuildInspectById(id);
    }
}
