package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import com.zehong.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TSiteTaskMapper;
import com.zehong.system.domain.TSiteTask;
import com.zehong.system.service.ITSiteTaskService;

/**
 * 场站巡检任务Service业务层处理
 * 
 * @author zehong
 * @date 2023-12-15
 */
@Service
public class TSiteTaskServiceImpl implements ITSiteTaskService 
{
    @Autowired
    private TSiteTaskMapper tSiteTaskMapper;

    /**
     * 查询场站巡检任务
     * 
     * @param id 场站巡检任务ID
     * @return 场站巡检任务
     */
    @Override
    public TSiteTask selectTSiteTaskById(Long id)
    {
        return tSiteTaskMapper.selectTSiteTaskById(id);
    }

    /**
     * 查询场站巡检任务列表
     * 
     * @param tSiteTask 场站巡检任务
     * @return 场站巡检任务
     */
    @Override
    public List<TSiteTask> selectTSiteTaskList(TSiteTask tSiteTask)
    {
        return tSiteTaskMapper.selectTSiteTaskList(tSiteTask);
    }

    /**
     *  小程序任务列表
     * @param tSiteTask
     * @return
     */
    @Override
    public List<TSiteTask> selectTSiteTaskwxList(TSiteTask tSiteTask)
    {
        return tSiteTaskMapper.selectTSiteTaskwxList(tSiteTask);
    }

    /**
     * 新增场站巡检任务
     * 
     * @param tSiteTask 场站巡检任务
     * @return 结果
     */
    @Override
    public int insertTSiteTask(TSiteTask tSiteTask)
    {
        tSiteTask.setCreateTime(DateUtils.getNowDate());
        tSiteTask.setAdminId(SecurityUtils.getLoginUser().getUser().getUserId());
        return tSiteTaskMapper.insertTSiteTask(tSiteTask);
    }

    /**
     * 修改场站巡检任务
     * 
     * @param tSiteTask 场站巡检任务
     * @return 结果
     */
    @Override
    public int updateTSiteTask(TSiteTask tSiteTask)
    {
        return tSiteTaskMapper.updateTSiteTask(tSiteTask);
    }

    /**
     * 批量删除场站巡检任务
     * 
     * @param ids 需要删除的场站巡检任务ID
     * @return 结果
     */
    @Override
    public int deleteTSiteTaskByIds(Long[] ids)
    {
        return tSiteTaskMapper.deleteTSiteTaskByIds(ids);
    }

    /**
     * 删除场站巡检任务信息
     * 
     * @param id 场站巡检任务ID
     * @return 结果
     */
    @Override
    public int deleteTSiteTaskById(Long id)
    {
        return tSiteTaskMapper.deleteTSiteTaskById(id);
    }
}
