package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TThirdBuild;

/**
 * 第三方施工Service接口
 * 
 * @author zehong
 * @date 2023-12-22
 */
public interface ITThirdBuildService 
{
    /**
     * 查询第三方施工
     * 
     * @param id 第三方施工ID
     * @return 第三方施工
     */
    public TThirdBuild selectTThirdBuildById(Long id);

    /**
     * 查询第三方施工列表
     * 
     * @param tThirdBuild 第三方施工
     * @return 第三方施工集合
     */
    public List<TThirdBuild> selectTThirdBuildList(TThirdBuild tThirdBuild);

    /**
     * 新增第三方施工
     * 
     * @param tThirdBuild 第三方施工
     * @return 结果
     */
    public int insertTThirdBuild(TThirdBuild tThirdBuild);

    /**
     * 修改第三方施工
     * 
     * @param tThirdBuild 第三方施工
     * @return 结果
     */
    public int updateTThirdBuild(TThirdBuild tThirdBuild);

    /**
     * 批量删除第三方施工
     * 
     * @param ids 需要删除的第三方施工ID
     * @return 结果
     */
    public int deleteTThirdBuildByIds(Long[] ids);

    /**
     * 删除第三方施工信息
     * 
     * @param id 第三方施工ID
     * @return 结果
     */
    public int deleteTThirdBuildById(Long id);
}
