package com.zehong.system.service;

import java.util.List;
import java.util.Map;

import com.zehong.system.domain.TTask;

/**
 * 入户安检任务Service接口
 * 
 * @author zehong
 * @date 2023-11-06
 */
public interface ITTaskService 
{
    /**
     * 查询入户安检任务
     * 
     * @param id 入户安检任务ID
     * @return 入户安检任务
     */
    public TTask selectTTaskById(Long id);

    /**
     * 查询入户安检任务列表
     * 
     * @param tTask 入户安检任务
     * @return 入户安检任务集合
     */
    public List<TTask> selectTTaskList(TTask tTask);

    /**
     * 新增入户安检任务
     * 
     * @param tTask 入户安检任务
     * @return 结果
     */
    public int insertTTask(TTask tTask);

    /**
     * 修改入户安检任务
     * 
     * @param tTask 入户安检任务
     * @return 结果
     */
    public int updateTTask(TTask tTask);

    /**
     * 批量删除入户安检任务
     * 
     * @param ids 需要删除的入户安检任务ID
     * @return 结果
     */
    public int deleteTTaskByIds(Long[] ids);

    /**
     * 删除入户安检任务信息
     * 
     * @param id 入户安检任务ID
     * @return 结果
     */
    public int deleteTTaskById(Long id);

    /**
     * 根据任务类型获取最新任务
     * @param param 参数
     * @return
     */
    TTask selectCurrentTaskByType(Map<String,Object> param);

    /**
     * 任务列表
     * @param tTask
     * @return
     */
    List<TTask> selecttasknums(TTask tTask);

    /**
     * 任务详情 任务统计
     * @param taskId 任务主键
     * @return
     */
    Map<String,Object> taskDetailInfo(Long taskId);

    /**
     * 任务详情任务进度统计
     * @param param
     * @return
     */
    Map<String,Object> taskInspectDetailInfo(Map<String,Object> param);

    /**
     * 任务详情隐患统计
     * @param taskId 任务主键
     * @return
     */
    Map<String,Object> taskInspectDangerDetailInfo(Long taskId);
}
