package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TTaskInspectExport;
import com.zehong.system.domain.vo.UserInspectExport;

/**
 * 安检单导出Service接口
 * 
 * @author zehong
 * @date 2024-10-16
 */
public interface ITTaskInspectExportService 
{
    /**
     * 查询安检单导出
     * 
     * @param exportId 安检单导出ID
     * @return 安检单导出
     */
    public TTaskInspectExport selectTTaskInspectExportById(Long exportId);

    /**
     * 查询安检单导出列表
     * 
     * @param tTaskInspectExport 安检单导出
     * @return 安检单导出集合
     */
    public List<TTaskInspectExport> selectTTaskInspectExportList(TTaskInspectExport tTaskInspectExport);

    /**
     * 新增安检单导出
     * 
     * @param tTaskInspectExport 安检单导出
     * @return 结果
     */
    public int insertTTaskInspectExport(TTaskInspectExport tTaskInspectExport);

    /**
     * 修改安检单导出
     * 
     * @param tTaskInspectExport 安检单导出
     * @return 结果
     */
    public int updateTTaskInspectExport(TTaskInspectExport tTaskInspectExport);

    /**
     * 批量删除安检单导出
     * 
     * @param exportIds 需要删除的安检单导出ID
     * @return 结果
     */
    public int deleteTTaskInspectExportByIds(Long[] exportIds);

    /**
     * 删除安检单导出信息
     * 
     * @param exportId 安检单导出ID
     * @return 结果
     */
    public int deleteTTaskInspectExportById(Long exportId);

    /**
     * 每日安检单导出
     * @param beginTime 开始时间
     * @param endTime 结束时间
     * @return
     */
    void batchExportInspect(String beginTime,String endTime,String taskId);

    /**
     * 导出压缩包
     * @param tTaskInspectExport
     * @return
     */
    String exportInspectZip(TTaskInspectExport tTaskInspectExport);
}
