package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TSiteTaskInspect;

/**
 * 场站巡检执行Service接口
 * 
 * @author zehong
 * @date 2023-12-15
 */
public interface ITSiteTaskInspectService 
{
    /**
     * 查询场站巡检执行
     * 
     * @param id 场站巡检执行ID
     * @return 场站巡检执行
     */
    public TSiteTaskInspect selectTSiteTaskInspectById(Long id);

    /**
     * 查询场站巡检执行列表
     * 
     * @param tSiteTaskInspect 场站巡检执行
     * @return 场站巡检执行集合
     */
    public List<TSiteTaskInspect> selectTSiteTaskInspectList(TSiteTaskInspect tSiteTaskInspect);

    /**
     * 新增场站巡检执行
     * 
     * @param tSiteTaskInspect 场站巡检执行
     * @return 结果
     */
    public int insertTSiteTaskInspect(TSiteTaskInspect tSiteTaskInspect);

    /**
     * 修改场站巡检执行
     * 
     * @param tSiteTaskInspect 场站巡检执行
     * @return 结果
     */
    public int updateTSiteTaskInspect(TSiteTaskInspect tSiteTaskInspect);

    /**
     * 批量删除场站巡检执行
     * 
     * @param ids 需要删除的场站巡检执行ID
     * @return 结果
     */
    public int deleteTSiteTaskInspectByIds(Long[] ids);

    /**
     * 删除场站巡检执行信息
     * 
     * @param id 场站巡检执行ID
     * @return 结果
     */
    public int deleteTSiteTaskInspectById(Long id);

    /**
     * 场站巡检记录
     * @param tSiteTaskInspect 巡检实体
     * @return
     */
    List<TSiteTaskInspect> selectSiteStationInspectInfo(TSiteTaskInspect tSiteTaskInspect);
}
