package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TPipeTaskUser;
import org.apache.ibatis.annotations.Param;

/**
 * 管线巡检起止Mapper接口
 * 
 * @author zehong
 * @date 2023-11-17
 */
public interface TPipeTaskUserMapper 
{
    /**
     * 查询管线巡检起止
     * 
     * @param id 管线巡检起止ID
     * @return 管线巡检起止
     */
    public TPipeTaskUser selectTPipeTaskUserById(Long id);

    /**
     * 查询管线巡检起止列表
     * 
     * @param tPipeTaskUser 管线巡检起止
     * @return 管线巡检起止集合
     */
    public List<TPipeTaskUser> selectTPipeTaskUserList(TPipeTaskUser tPipeTaskUser);

    /**
     * 新增管线巡检起止
     * 
     * @param tPipeTaskUser 管线巡检起止
     * @return 结果
     */
    public int insertTPipeTaskUser(TPipeTaskUser tPipeTaskUser);

    /**
     * 修改管线巡检起止
     * 
     * @param tPipeTaskUser 管线巡检起止
     * @return 结果
     */
    public int updateTPipeTaskUser(TPipeTaskUser tPipeTaskUser);

    /**
     * 删除管线巡检起止
     * 
     * @param id 管线巡检起止ID
     * @return 结果
     */
    public int deleteTPipeTaskUserById(Long id);

    /**
     * 批量删除管线巡检起止
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    public int deleteTPipeTaskUserByIds(Long[] ids);

    public TPipeTaskUser selectByuserIdTaskId(@Param("userId")Long userId,@Param("taskId")Long taskId);
}
