package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TGasAlarm;

/**
 * 报警器报警记录Mapper接口
 * 
 * @author zehong
 * @date 2024-09-10
 */
public interface TGasAlarmMapper 
{
    /**
     * 查询报警器报警记录
     * 
     * @param id 报警器报警记录ID
     * @return 报警器报警记录
     */
    public TGasAlarm selectTGasAlarmById(Long id);

    /**
     * 查询报警器报警记录列表
     * 
     * @param tGasAlarm 报警器报警记录
     * @return 报警器报警记录集合
     */
    public List<TGasAlarm> selectTGasAlarmList(TGasAlarm tGasAlarm);

    /**
     * 新增报警器报警记录
     * 
     * @param tGasAlarm 报警器报警记录
     * @return 结果
     */
    public int insertTGasAlarm(TGasAlarm tGasAlarm);

    /**
     * 修改报警器报警记录
     * 
     * @param tGasAlarm 报警器报警记录
     * @return 结果
     */
    public int updateTGasAlarm(TGasAlarm tGasAlarm);

    /**
     * 删除报警器报警记录
     * 
     * @param id 报警器报警记录ID
     * @return 结果
     */
    public int deleteTGasAlarmById(Long id);

    /**
     * 批量删除报警器报警记录
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    public int deleteTGasAlarmByIds(Long[] ids);
}
