package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TDeviceTask;

/**
 * 设备巡检任务Mapper接口
 * 
 * @author zehong
 * @date 2023-12-11
 */
public interface TDeviceTaskMapper 
{
    /**
     * 查询设备巡检任务
     * 
     * @param id 设备巡检任务ID
     * @return 设备巡检任务
     */
    public TDeviceTask selectTDeviceTaskById(Long id);

    /**
     * 查询设备巡检任务列表
     * 
     * @param tDeviceTask 设备巡检任务
     * @return 设备巡检任务集合
     */
    public List<TDeviceTask> selectTDeviceTaskList(TDeviceTask tDeviceTask);

    /**
     * 小程序设备巡检列表
     * @return
     */
    public List<TDeviceTask> selectTDeviceTaskNum(TDeviceTask tDeviceTask);

    /**
     * 新增设备巡检任务
     * 
     * @param tDeviceTask 设备巡检任务
     * @return 结果
     */
    public int insertTDeviceTask(TDeviceTask tDeviceTask);

    /**
     * 修改设备巡检任务
     * 
     * @param tDeviceTask 设备巡检任务
     * @return 结果
     */
    public int updateTDeviceTask(TDeviceTask tDeviceTask);

    /**
     * 删除设备巡检任务
     * 
     * @param id 设备巡检任务ID
     * @return 结果
     */
    public int deleteTDeviceTaskById(Long id);

    /**
     * 批量删除设备巡检任务
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    public int deleteTDeviceTaskByIds(Long[] ids);
}
