package com.zehong.system.mapper;

import java.util.List;

import com.zehong.system.domain.TDeviceInfo;
import com.zehong.system.domain.TDeviceTaskInspect;

/**
 * 设备巡检执行Mapper接口
 * 
 * @author zehong
 * @date 2023-12-11
 */
public interface TDeviceTaskInspectMapper 
{
    /**
     * 查询设备巡检执行
     * 
     * @param id 设备巡检执行ID
     * @return 设备巡检执行
     */
    public TDeviceTaskInspect selectTDeviceTaskInspectById(Long id);

    /**
     * 查询设备巡检执行列表
     *
     * @param tDeviceTaskInspect 设备巡检执行
     * @return 设备巡检执行集合
     */
    public List<TDeviceTaskInspect> selectTDeviceTaskInspectList(TDeviceTaskInspect tDeviceTaskInspect);


    /**
     * 新增设备巡检执行
     * 
     * @param tDeviceTaskInspect 设备巡检执行
     * @return 结果
     */
    public int insertTDeviceTaskInspect(TDeviceTaskInspect tDeviceTaskInspect);

    /**
     * 修改设备巡检执行
     * 
     * @param tDeviceTaskInspect 设备巡检执行
     * @return 结果
     */
    public int updateTDeviceTaskInspect(TDeviceTaskInspect tDeviceTaskInspect);

    /**
     * 删除设备巡检执行
     * 
     * @param id 设备巡检执行ID
     * @return 结果
     */
    public int deleteTDeviceTaskInspectById(Long id);

    /**
     * 批量删除设备巡检执行
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    public int deleteTDeviceTaskInspectByIds(Long[] ids);

    /**
     * 设备巡检信息
     * @param tDeviceTaskInspect 巡检实体
     * @return
     */
    List<TDeviceTaskInspect> selectTDeviceTaskInspectInfoList(TDeviceTaskInspect tDeviceTaskInspect);
}
